
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Product Child Category')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Product Child Category')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.product-category.index')); ?>"><?php echo e(__('admin.Product Category')); ?></a></div>
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.product-sub-category.index')); ?>"><?php echo e(__('admin.Product Sub Category')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Product Child Category')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product-child-category.create')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('admin.Add New')); ?></a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('admin.SN')); ?></th>
                                    <th><?php echo e(__('admin.Child Category')); ?></th>
                                    <th><?php echo e(__('admin.Slug')); ?></th>
                                    <th><?php echo e(__('admin.Sub Category')); ?></th>
                                    <th><?php echo e(__('admin.Category')); ?></th>
                                    <th><?php echo e(__('admin.Status')); ?></th>
                                    <th><?php echo e(__('admin.Action')); ?></th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $childCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><?php echo e($childCategory->name); ?></td>
                                        <td><?php echo e($childCategory->slug); ?></td>
                                        <td><?php echo e($childCategory->subCategory->name); ?></td>
                                        <td><?php echo e($childCategory->category->name); ?></td>
                                        <td>
                                            <?php if($childCategory->status == 1): ?>
                                            <a href="javascript:;" onclick="changeProductSubCategoryStatus(<?php echo e($childCategory->id); ?>)">
                                                <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php else: ?>
                                            <a href="javascript:;" onclick="changeProductSubCategoryStatus(<?php echo e($childCategory->id); ?>)">
                                                <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.InActive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                        <a href="<?php echo e(route('admin.product-child-category.edit',$childCategory->id)); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                        <?php
                                            $isPopular = false;
                                            if($pupoularCategory->child_category_id_one == $childCategory->id){
                                                $isPopular = true;
                                            }else if($pupoularCategory->child_category_id_two == $childCategory->id){
                                                $isPopular = true;
                                            }else if($pupoularCategory->child_category_id_three == $childCategory->id){
                                                $isPopular = true;
                                            }else if($pupoularCategory->child_category_id_four == $childCategory->id){
                                                $isPopular = true;
                                            }

                                            $isThreeCat = false;
                                            if($threeColCategory->child_category_id_one == $childCategory->id){
                                                $isThreeCat = true;
                                            }else if($threeColCategory->child_category_id_two == $childCategory->id){
                                                $isThreeCat = true;
                                            }else if($threeColCategory->child_category_id_three == $childCategory->id){
                                                $isThreeCat = true;
                                            }
                                        ?>
                                        <?php if($childCategory->products->count() == 0 && !$isThreeCat && !$isPopular): ?>
                                            <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($childCategory->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php else: ?>
                                            <a href="javascript:;" data-toggle="modal" data-target="#canNotDeleteModal" class="btn btn-danger btn-sm" disabled><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php endif; ?>

                                        </td>
                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

      <!-- Modal -->
      <div class="modal fade" id="canNotDeleteModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                      <div class="modal-body">
                          <?php echo e(__('admin.You can not delete this child category. Because there are one or more popular child categories or home page three column categories or products has been created in this child category.')); ?>

                      </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/product-child-category/")); ?>'+"/"+id)
    }
    function changeProductSubCategoryStatus(id){
        var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '<?php echo e(csrf_token()); ?>' },
            url:"<?php echo e(url('/admin/product-child-category-status/')); ?>"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){}
        })
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/product_child_category.blade.php ENDPATH**/ ?>