
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Track Order')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e(__('user.Track Order')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Track Order')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('track-order')); ?>"><?php echo e(__('user.Track Order')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
        TRACKING ORDER START
    ==============================-->
    <section id="wsus__login_register">
        <div class="container">
            <div class="wsus__track_area">
                <div class="row">
                    <div class="col-xl-5 col-md-10 col-lg-8 m-auto">
                        <form id="orderTrackForm" class="tack_form">
                            <h4 class="text-center"><?php echo e(__('user.Order Tracking')); ?></h4>
                            <p class="text-center"><?php echo e(__('user.Tracking your order status')); ?></p>
                            <div class="wsus__track_input">
                                <label class="d-block mb-2"><?php echo e(__('user.order id')); ?>*</label>
                                <input type="text" name="order_id" id="order_id" required placeholder="4785**541">
                            </div>
                            <button type="submit" class="common_btn"><?php echo e(__('user.track')); ?></button>
                        </form>
                    </div>
                </div>
                <div class="row" id="ajax_response">

                </div>
            </div>
        </div>
    </section>
    <!--============================
        TRACKING ORDER END
    ==============================-->




    <script>
        (function($) {
            "use strict";
            $(document).ready(function () {
                $("#orderTrackForm").on('submit', function(e){
                    e.preventDefault();
                    let orderId = $("#order_id").val();
                    $.ajax({
                        type: 'get',
                        url: "<?php echo e(url('track-order-response')); ?>"+ "/" + orderId,
                        success: function (response) {
                            if(response.status == 0){
                                toastr.error(response.message);
                            }else{
                                $("#ajax_response").html(response);

                            }

                        },
                        error: function(err) {
                        }
                    });
                })
            });
        })(jQuery);
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/track_order.blade.php ENDPATH**/ ?>