
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Announcement')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Announcement')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Announcement')); ?></div>
            </div>
          </div>

          <div class="section-body">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.announcement-update')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Announcement Status')); ?></label>
                                <div>
                                    <?php if($announcement->status == 1): ?>
                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                        <?php else: ?>
                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Existing Image')); ?></label>
                                <div>
                                    <img src="<?php echo e(asset($announcement->image)); ?>" width="200px" alt="">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.New Image')); ?></label>
                                <input type="file" class="form-control-file" name="image">
                            </div>
                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Title')); ?></label>
                                <input type="text" class="form-control" name="title" value="<?php echo e($announcement->title); ?>">
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Description')); ?></label>
                                <textarea name="description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($announcement->description); ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Footer Text')); ?></label>
                                <input type="text" class="form-control" name="footer_text" value="<?php echo e($announcement->footer_text); ?>">
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Session Expired Date Quantity')); ?></label>
                                <input type="number" class="form-control" name="expired_date" value="<?php echo e($announcement->expired_date); ?>">
                            </div>



                            <button class="btn btn-primary" type="submit"><?php echo e(__('admin.Update')); ?></button>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/announcement.blade.php ENDPATH**/ ?>