
<?php $__env->startSection('title'); ?>
    <title><?php echo e($product->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($product->seo_description); ?> <?php echo e($tags); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($product->banner_image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Product')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <li><a href="<?php echo e(route('product')); ?>"><?php echo e(__('user.Product')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->
<!--============================
        PRODUCT DETAILS START
    ==============================-->
    <section id="wsus__product_details">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-md-5 col-lg-5">
                    <div id="sticky_pro_zoom">
                        <div class="exzoom hidden" id="exzoom">
                            <div class="exzoom_img_box">
                                <?php if($product->video_link): ?>
                                    <?php
                                        $video_id=explode("=",$product->video_link);
                                    ?>
                                    <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                        href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                        <i class="fas fa-play"></i>
                                    </a>
                                <?php endif; ?>
                                <ul class='exzoom_img_ul'>
                                    <?php $__currentLoopData = $product->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><img class="zoom ing-fluid w-100" src="<?php echo e(asset($image->image)); ?>" alt="product"></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </ul>
                            </div>
                            <div class="exzoom_nav"></div>
                            <p class="exzoom_btn">
                                <a href="javascript:void(0);" class="exzoom_prev_btn"> <i class="far fa-chevron-left"></i> </a>
                                <a href="javascript:void(0);" class="exzoom_next_btn"> <i class="far fa-chevron-right"></i> </a>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-5 col-md-7 col-lg-7">
                    <div class="wsus__pro_details_text">
                        <a class="title" href="javascript:;"><?php echo e($product->name); ?></a>
                            <input type="hidden" id="stock_qty" value="<?php echo e($product->qty); ?>">
                            <?php if($product->qty == 0): ?>
                            <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                            <?php else: ?>
                                <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?></span>
                                    <?php if($setting->show_product_qty == 1): ?>
                                    (<?php echo e($product->qty); ?> <?php echo e(__('user.item')); ?>)
                                    <?php endif; ?>
                                </p>
                            <?php endif; ?>


                        <?php
                            $reviewQty = $product->reviews->where('status',1)->count();
                            $totalReview = $product->reviews->where('status',1)->sum('rating');

                            if ($reviewQty > 0) {
                                $average = $totalReview / $reviewQty;

                                $intAverage = intval($average);

                                $nextValue = $intAverage + 1;
                                $reviewPoint = $intAverage;
                                $halfReview=false;
                                if($intAverage < $average && $average < $nextValue){
                                    $reviewPoint= $intAverage + 0.5;
                                    $halfReview=true;
                                }
                            }
                        ?>

                        <?php
                            $variantPrice = 0;
                            $variants = $product->variants->where('status', 1);
                            if($variants->count() != 0){
                                foreach ($variants as $variants_key => $variant) {
                                    if($variant->variantItems->where('status',1)->count() != 0){
                                        $item = $variant->variantItems->where('is_default',1)->first();
                                        if($item){
                                            $variantPrice += $item->price;
                                        }
                                    }
                                }
                            }
                            $isCampaign = false;
                            $today = date('Y-m-d H:i:s');
                            $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $product->id])->first();
                            if($campaign){
                                $campaign = $campaign->campaign;
                                if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                    $isCampaign = true;
                                }
                                $campaignOffer = $campaign->offer;
                                $productPrice = $product->price;
                                $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                $totalPrice = $product->price;
                                $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                            }

                            $totalPrice = $product->price;
                            if($product->offer_price != null){
                                $offerPrice = $product->offer_price;
                                $offer = $totalPrice - $offerPrice;
                                $percentage = ($offer * 100) / $totalPrice;
                                $percentage = round($percentage);
                            }


                        ?>

                        <?php if($isCampaign): ?>
                            <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductPrice"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                        <?php else: ?>
                            <?php if($product->offer_price == null): ?>
                                <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductPrice"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span> </h4>
                            <?php else: ?>
                                <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductPrice"><?php echo e(sprintf("%.2f", $product->offer_price + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                            <?php endif; ?>
                        <?php endif; ?>


                        <?php if($reviewQty > 0): ?>
                            <p class="review">
                                <?php for($i = 1; $i <=5; $i++): ?>
                                    <?php if($i <= $reviewPoint): ?>
                                        <i class="fas fa-star"></i>
                                    <?php elseif($i> $reviewPoint ): ?>
                                        <?php if($halfReview==true): ?>
                                        <i class="fas fa-star-half-alt"></i>
                                            <?php
                                                $halfReview=false
                                            ?>
                                        <?php else: ?>
                                        <i class="fal fa-star"></i>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                            </p>
                        <?php endif; ?>

                        <?php if($reviewQty == 0): ?>
                            <p class="review">
                                <i class="fal fa-star"></i>
                                <i class="fal fa-star"></i>
                                <i class="fal fa-star"></i>
                                <i class="fal fa-star"></i>
                                <i class="fal fa-star"></i>
                                <span>(0 <?php echo e(__('user.review')); ?>)</span>
                            </p>
                        <?php endif; ?>

                        <p class="description"><?php echo e($product->short_description); ?></p>

                        <?php if($product->is_flash_deal == 1): ?>
                            <?php
                                $end_time = $product->flash_deal_date;
                            ?>
                            <script>
                                var end_year = <?php echo e(date('Y', strtotime($end_time))); ?>;
                                var end_month = <?php echo e(date('m', strtotime($end_time))); ?>;
                                var end_date = <?php echo e(date('d', strtotime($end_time))); ?>;
                            </script>
                            <div class="wsus_pro_hot_deals">
                                <h5><?php echo e(__('user.offer ending time')); ?> : </h5>
                                <div class="simply-countdown product-details"></div>
                            </div>
                        <?php endif; ?>

                        <?php
                            $productPrice = 0;
                            if($isCampaign){
                                $productPrice = $campaignOfferPrice + $variantPrice;
                            }else{
                                if ($product->offer_price == null) {
                                    $productPrice = $totalPrice + $variantPrice;
                                }else {
                                    $productPrice = $product->offer_price + $variantPrice;
                                }
                            }
                        ?>

                        <form id="shoppingCartForm">
                        <div class="wsus__quentity">
                            <h5><?php echo e(__('user.Quantity')); ?> :</h5>
                            <div class="modal_btn">
                                <button type="button" class="btn btn-danger btn-sm decrementProduct">-</button>
                                <input class="form-control product_qty" name="quantity" readonly type="text" min="1" max="<?php echo e($product->qty); ?>" value="1" data-qty="<?php echo e($product->qty); ?>"/>
                                <button type="button" class="btn btn-success btn-sm incrementProduct">+</button>
                            </div>
                            <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="product_price"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>
                        </div>

                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                        <input type="hidden" name="image" value="<?php echo e($product->thumb_image); ?>">
                        <input type="hidden" name="slug" value="<?php echo e($product->slug); ?>">

                        <?php if($productVariants->count() != 0): ?>
                            <div class="wsus__selectbox">
                                <div class="row">
                                    <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $product->id])->get();
                                        ?>
                                        <?php if($items->count() != 0): ?>
                                            <div class="col-xl-6 col-sm-6 mb-3">
                                                <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                <select class="select_2 productVariant" name="items[]">
                                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>




                        <ul class="wsus__button_area">
                            <li><button type="submit" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                            <li><a class="buy_now" href="javascript:;" id="buyNowBtn"><?php echo e(__('user.buy now')); ?></a></li>
                            <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($product->id); ?>')"><i class="fal fa-heart"></i></a></li>
                            <li><a href="javascript:;" onclick="addToCompare('<?php echo e($product->id); ?>')"><i class="far fa-random"></i></a></li>
                        </ul>

                    </form>
                        <?php if($product->sku): ?>
                        <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($product->sku); ?></p>
                        <?php endif; ?>

                        <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $product->brand->slug])); ?>"><?php echo e($product->brand->name); ?></a></p>
                        <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $product->category->slug])); ?>"><?php echo e($product->category->name); ?></a></p>
                        <div class="wsus__pro_det_share d-none">
                            <h5><?php echo e(__('user.share')); ?> :</h5>
                            <ul class="d-flex">
                                <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $product->slug)); ?>&t=<?php echo e($product->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($product->name); ?>&url=<?php echo e(route('product-detail', $product->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $product->slug)); ?>&title=<?php echo e($product->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($product->name); ?>&media=&url=<?php echo e(route('product-detail', $product->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                            </ul>
                        </div>
                        <?php if(auth()->guard()->check()): ?>
                            <?php
                                $user = Auth::guard('web')->user();
                                $isExist = false;
                                $orders = App\Models\Order::where(['user_id' => $user->id])->get();
                                foreach ($orders as $key => $order) {
                                    foreach ($order->orderProducts as $key => $orderProduct) {
                                        if($orderProduct->product_id == $product->id){
                                            $isExist = true;
                                        }
                                    }
                                }
                            ?>
                        <?php if($isExist): ?>
                            <a class="wsus__pro_report" href="#" data-bs-toggle="modal" data-bs-target="#productReportModal"><i
                            class="fal fa-comment-alt-smile"></i> <?php echo e(__('user.Report incorrect product information')); ?></a>
                        <?php endif; ?>

                        <?php endif; ?>

                    </div>

                    <!--==========================
                    PRODUCT  REPORT MODAL VIEW
                    ===========================-->
                    <?php if(auth()->guard()->check()): ?>
                        <?php if($isExist): ?>
                            <section class="product_popup_modal report_modal">
                                <div class="modal fade" id="productReportModal" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title"><?php echo e(__('user.Report Product')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                                        class="far fa-times"></i></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <form id="reportModalForm">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="wsus__single_input">
                                                                <label><?php echo e(__('user.Subject')); ?></label>
                                                                <input type="text" name="subject" placeholder="<?php echo e(__('user.Type Subject')); ?>">
                                                                <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                                <input type="hidden" name="seller_id" value="<?php echo e($product->vendor_id); ?>">
                                                            </div>
                                                            <div class="wsus__single_input">
                                                                <label><?php echo e(__('user.Description')); ?></label>
                                                                <textarea name="description" cols="3" rows="3"
                                                                    placeholder="<?php echo e(__('user.Description')); ?>"></textarea>
                                                            </div>

                                                            <button type="submit" class="common_btn"><?php echo e(__('user.submit')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        <?php endif; ?>
                    <?php endif; ?>
                    <!--==========================
                    PRODUCT REPORT MODAL VIEW
                    ===========================-->
                </div>

                <div class="col-xl-3 col-md-12 mt-md-5 mt-lg-0">
                    <div class="wsus_pro_det_sidebar" id="sticky_sidebar">
                        <div class="lg_area">
                            <div class="wsus_pro_det_sidebar_single">
                                <i class="fal fa-truck"></i>
                                <div class="wsus_pro_det_sidebar_text">

                                    <?php if($product->is_return == 1): ?>
                                    <h5><?php echo e(__('user.Return Available')); ?></h5>
                                    <p><?php echo e($product->returnPolicy->details); ?></p>
                                    <?php else: ?>
                                        <h5><?php echo e(__('user.Return Not Available')); ?></h5>
                                    <?php endif; ?>

                                </div>
                            </div>


                            <div class="wsus_pro_det_sidebar_single">
                                <i class="far fa-shield-check"></i>
                                <div class="wsus_pro_det_sidebar_text">
                                    <h5><?php echo e(__('user.Secure Payment')); ?></h5>
                                    <p><?php echo e(__('user.We ensure secure payment')); ?></p>
                                </div>
                            </div>
                            <div class="wsus_pro_det_sidebar_single">
                                <i class="fal fa-envelope-open-dollar"></i>
                                <div class="wsus_pro_det_sidebar_text">
                                    <?php if($product->is_warranty == 1): ?>
                                    <h5><?php echo e(__('user.Warranty Available')); ?></h5>
                                    <?php else: ?>
                                    <h5><?php echo e(__('user.Warranty Not Available')); ?></h5>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php if($banner->status == 1): ?>
                            <div class="wsus__det_sidebar_banner">
                                <img src="<?php echo e(asset($banner->image)); ?>" alt="banner" class="img-fluid w-100">
                                    <div class="wsus__det_sidebar_banner_text_overlay">
                                    <div class="wsus__det_sidebar_banner_text">
                                        <p><?php echo e($banner->title); ?></p>
                                        <h4><?php echo e($banner->description); ?></h4>
                                        <a href="<?php echo e($banner->link); ?>" class="common_btn"><?php echo e(__('user.shop now')); ?></a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>
                <div class="col-xl-12">
                    <div class="wsus__pro_det_description">
                        <ul class="nav nav-pills mb-3" id="pills-tab3" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pills-home-tab7" data-bs-toggle="pill"
                                    data-bs-target="#pills-home22" type="button" role="tab" aria-controls="pills-home"
                                    aria-selected="true"><?php echo e(__('user.Description')); ?></button>
                            </li>
                            <?php if($product->is_specification == 1): ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-profile-tab7" data-bs-toggle="pill"
                                    data-bs-target="#pills-profile22" type="button" role="tab"
                                    aria-controls="pills-profile" aria-selected="false"><?php echo e(__('user.Specification')); ?></button>
                            </li>
                            <?php endif; ?>

                            <?php if($product->vendor_id != 0): ?>
                            <?php if($setting->enable_multivendor == 1): ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-contact" type="button" role="tab"
                                    aria-controls="pills-contact" aria-selected="false"><?php echo e(__('user.Seller Information')); ?></button>
                            </li>
                            <?php endif; ?>
                            <?php endif; ?>

                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-contact-tab2" data-bs-toggle="pill"
                                    data-bs-target="#pills-contact2" type="button" role="tab"
                                    aria-controls="pills-contact2" aria-selected="false"><?php echo e(__('user.Reviews')); ?></button>
                            </li>

                        </ul>
                        <div class="tab-content" id="pills-tabContent4">
                            <div class="tab-pane fade  show active " id="pills-home22" role="tabpanel"
                                aria-labelledby="pills-home-tab7">
                                <div class="row">
                                    <div class="col-12">
                                        <?php echo $product->long_description; ?>

                                    </div>


                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-profile22" role="tabpanel"
                                aria-labelledby="pills-profile-tab7">
                                <div class="row">
                                    <div class="col-xl-6 col-lg-6 mb-4 mb-lg-0">
                                        <div class="wsus__pro_det_info">
                                            <h4><?php echo e(__('user.Additional Information')); ?></h4>
                                            <?php $__currentLoopData = $product->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <p><span><?php echo e($specification->key->key); ?></span> <span><?php echo e($specification->specification); ?></span></p>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <?php if($product->vendor_id != 0): ?>
                            <?php
                                $user = $product->seller;
                                $user = $user->user;
                            ?>
                            <div class="tab-pane fade" id="pills-contact" role="tabpanel"
                                aria-labelledby="pills-contact-tab">
                                <div class="wsus__pro_det_vendor">
                                    <div class="row">
                                        <div class="col-xl-6 col-xxl-5 col-md-6">
                                            <div class="wsus__vebdor_img">
                                                <?php if($user->image): ?>
                                                <img src="<?php echo e(asset($user->image)); ?>" alt="vensor" class="img-fluid w-100">
                                                <?php else: ?>
                                                <img src="<?php echo e(asset($defaultProfile->image)); ?>" alt="vensor" class="img-fluid w-100">
                                                <?php endif; ?>

                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-xxl-7 col-md-6 mt-4 mt-md-0">
                                            <div class="wsus__pro_det_vendor_text">
                                                <h4><?php echo e($user->name); ?></h4>
                                                <?php
                                                    $reviewQty = App\Models\ProductReview::where('status',1)->where('product_vendor_id',$product->vendor_id)->count();
                                                    $totalReview = App\Models\ProductReview::where('status',1)->where('product_vendor_id',$product->vendor_id)->sum('rating');
                                                    if ($reviewQty > 0) {
                                                        $average = $totalReview / $reviewQty;
                                                        $intAverage = intval($average);
                                                        $nextValue = $intAverage + 1;
                                                        $reviewPoint = $intAverage;
                                                        $halfReview = false;
                                                        if($intAverage < $average && $average < $nextValue){
                                                            $reviewPoint= $intAverage + 0.5;
                                                            $halfReview=true;
                                                        }
                                                    }
                                                ?>

                                                <?php if($reviewQty > 0): ?>
                                                <p class="rating">
                                                    <?php for($i = 1; $i <=5; $i++): ?>
                                                        <?php if($i <= $reviewPoint): ?>
                                                            <i class="fas fa-star"></i>
                                                        <?php elseif($i> $reviewPoint ): ?>
                                                            <?php if($halfReview==true): ?>
                                                            <i class="fas fa-star-half-alt"></i>
                                                                <?php
                                                                    $halfReview=false
                                                                ?>
                                                            <?php else: ?>
                                                            <i class="fal fa-star"></i>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                    <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                </p>
                                                <?php endif; ?>

                                                <?php if($reviewQty == 0): ?>
                                                    <p class="rating">
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                    </p>
                                                <?php endif; ?>

                                                <p><span><?php echo e(__('user.Store Name')); ?>:</span> <?php echo e($user->seller->shop_name); ?></p>
                                                <p><span><?php echo e(__('user.Address')); ?>:</span> <?php echo e($user->address); ?> <?php echo e($user->city ? ','.$user->city->name : ''); ?> <?php echo e($user->city ? ','.$user->city->countryState->name : ''); ?> <?php echo e($user->city ? ','.$user->city->countryState->country->name : ''); ?></p>
                                                <p><span><?php echo e(__('user.Phone')); ?>:</span> <?php echo e($user->phone); ?></p>
                                                <p><span><?php echo e(__('user.mail')); ?>:</span> <?php echo e($user->email); ?></p>
                                                <a href="<?php echo e(route('seller-detail',['shop_name' => $user->seller->slug])); ?>" class="see_btn"><?php echo e(__('user.visit store')); ?></a>
                                                <a href="<?php echo e(route('user.chat-with-seller', $user->seller->slug)); ?>" class="see_btn"><?php echo e(__('user.Chat with Seller')); ?></a>
                                            </div>
                                        </div>
                                        <div class="col-xl-12">
                                            <div class="wsus__vendor_details">
                                                <?php echo clean($user->seller->description); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="tab-pane fade" id="pills-contact2" role="tabpanel"
                                aria-labelledby="pills-contact-tab2">
                                <div class="wsus__pro_det_review">
                                    <div class="wsus__pro_det_review_single">
                                        <div class="row">
                                            <div class="col-xl-8 col-lg-7">
                                                <div class="wsus__comment_area">
                                                    <h4><?php echo e(__('user.Reviews')); ?> <span><?php echo e($totalProductReviewQty); ?></span></h4>
                                                    <?php $__currentLoopData = $productReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="wsus__main_comment">
                                                        <div class="wsus__comment_img">
                                                            <img src="<?php echo e($review->user->image ? asset($review->user->image) : asset($defaultProfile->image)); ?>" alt="user"
                                                                class="img-fluid w-100">
                                                        </div>
                                                        <div class="wsus__comment_text replay">
                                                            <h6><?php echo e($review->user->name); ?> <span><?php echo e($review->rating); ?> <i
                                                                        class="fas fa-star"></i></span></h6>
                                                            <span><?php echo e($review->created_at->format('d M, Y')); ?></span>
                                                            <p>
                                                                <?php echo e($review->review); ?>

                                                            </p>
                                                        </div>
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($productReviews->links('custom_paginator')); ?>

                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-lg-5 mt-4 mt-lg-0">
                                                <div class="wsus__post_comment rev_mar" id="sticky_sidebar3">
                                                    <h4><?php echo e(__('user.write a Review')); ?></h4>
                                                    <form id="reviewFormId">
                                                        <?php echo csrf_field(); ?>
                                                        <p class="rating">
                                                            <span><?php echo e(__('user.select your rating')); ?> : </span>
                                                            <i class="fas fa-star product_rat" data-rating="1" onclick="productReview(1)"></i>
                                                            <i class="fas fa-star product_rat" data-rating="2" onclick="productReview(2)"></i>
                                                            <i class="fas fa-star product_rat" data-rating="3" onclick="productReview(3)"></i>
                                                            <i class="fas fa-star product_rat" data-rating="4" onclick="productReview(4)"></i>
                                                            <i class="fas fa-star product_rat" data-rating="5" onclick="productReview(5)"></i>
                                                        </p>
                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <div class="col-xl-12">
                                                                    <div class="wsus__single_com">
                                                                        <textarea name="review" cols="3" rows="3"
                                                                            placeholder="<?php echo e(__('user.Write your review')); ?>"></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <input type="hidden" id="product_id" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="rating" value="5" id="product_rating">
                                                        <input type="hidden" name="seller_id" value="<?php echo e($product->vendor_id); ?>">

                                                        <?php if($recaptchaSetting->status==1): ?>
                                                            <div class="col-xl-12">
                                                                <div class="wsus__single_com mb-3">
                                                                    <div class="g-recaptcha" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if(auth()->guard()->check()): ?>
                                                        <button class="common_btn" type="submit"><?php echo e(__('user.submit review')); ?></button>
                                                        <?php else: ?>
                                                        <a class="login_link" href="<?php echo e(route('login')); ?>"><?php echo e(__('user.Before submit review, please login first')); ?></a>
                                                        <?php endif; ?>

                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        PRODUCT DETAILS END
    ==============================-->


        <!--============================
        RELATED PRODUCT START
    ==============================-->
    <?php if($relatedProducts->count() > 0): ?>
    <section id="wsus__flash_sell">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__section_header">
                        <h3><?php echo e(__('user.Related Products')); ?></h3>
                        <a class="see_btn" href="<?php echo e(route('product',['category' => $product->category->slug])); ?>"><?php echo e(__('user.see more')); ?> <i class="fas fa-caret-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="row flash_sell_slider ">
                <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $reviewQty = $relatedProduct->reviews->where('status',1)->count();
                        $totalReview = $relatedProduct->reviews->where('status',1)->sum('rating');

                        if ($reviewQty > 0) {
                            $average = $totalReview / $reviewQty;

                            $intAverage = intval($average);

                            $nextValue = $intAverage + 1;
                            $reviewPoint = $intAverage;
                            $halfReview=false;
                            if($intAverage < $average && $average < $nextValue){
                                $reviewPoint= $intAverage + 0.5;
                                $halfReview=true;
                            }
                        }
                    ?>

                    <?php
                        $variantPrice = 0;
                        $variants = $relatedProduct->variants->where('status', 1);
                        if($variants->count() != 0){
                            foreach ($variants as $variants_key => $variant) {
                                if($variant->variantItems->where('status',1)->count() != 0){
                                    $item = $variant->variantItems->where('is_default',1)->first();
                                    if($item){
                                        $variantPrice += $item->price;
                                    }
                                }
                            }
                        }

                        $isCampaign = false;
                        $today = date('Y-m-d H:i:s');

                        $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $relatedProduct->id])->first();
                        if($campaign){

                            $campaign = $campaign->campaign;
                            if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                $isCampaign = true;
                            }

                            $campaignOffer = $campaign->offer;
                            $productPrice = $relatedProduct->price;
                            $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                            $totalPrice = $productPrice;
                            $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                        }

                        $totalPrice = $relatedProduct->price;
                        if($relatedProduct->offer_price != null){
                            $offerPrice = $relatedProduct->offer_price;
                            $offer = $totalPrice - $offerPrice;
                            $percentage = ($offer * 100) / $totalPrice;
                            $percentage = round($percentage);
                        }

                    ?>
                    <div class="col-xl-3">
                        <div class="wsus__product_item wsus__after">
                            <?php if($relatedProduct->new_product == 1): ?>
                                <span class="wsus__new"><?php echo e(__('user.New')); ?></span>
                            <?php elseif($relatedProduct->is_featured == 1): ?>
                                <span class="wsus__new"><?php echo e(__('user.Featured')); ?></span>
                            <?php elseif($relatedProduct->is_top == 1): ?>
                                <span class="wsus__new"><?php echo e(__('user.Top')); ?></span>
                            <?php elseif($relatedProduct->is_best == 1): ?>
                                <span class="wsus__new"><?php echo e(__('user.Best')); ?></span>
                            <?php endif; ?>

                            <?php if($isCampaign): ?>
                                <span class="wsus__minus">-<?php echo e($campaignOffer); ?>%</span>
                            <?php else: ?>
                                <?php if($relatedProduct->offer_price != null): ?>
                                    <span class="wsus__minus">-<?php echo e($percentage); ?>%</span>
                                <?php endif; ?>
                            <?php endif; ?>
                            <a class="wsus__pro_link" href="<?php echo e(route('product-detail', $relatedProduct->slug)); ?>">
                                <img src="<?php echo e(asset($relatedProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_1" />
                                <img src="<?php echo e(asset($relatedProduct->thumb_image)); ?>" alt="product" class="img-fluid w-100 img_2" />
                            </a>

                            <ul class="wsus__single_pro_icon">
                                <li><a data-bs-toggle="modal" data-bs-target="#productModalView-<?php echo e($relatedProduct->id); ?>"><i class="fal fa-eye"></i></a></li>
                                <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($relatedProduct->id); ?>')"><i class="far fa-heart"></i></a></li>
                                <li><a href="javascript:;" onclick="addToCompare('<?php echo e($relatedProduct->id); ?>')"><i class="far fa-random"></i></a>
                                </li>
                            </ul>
                            <div class="wsus__product_details">
                                <a class="wsus__category" href="<?php echo e(route('product',['category' => $relatedProduct->category->slug])); ?>"><?php echo e($relatedProduct->category->name); ?> </a>

                                <?php if($reviewQty > 0): ?>
                                    <p class="wsus__pro_rating">
                                        <?php for($i = 1; $i <=5; $i++): ?>
                                            <?php if($i <= $reviewPoint): ?>
                                                <i class="fas fa-star"></i>
                                            <?php elseif($i> $reviewPoint ): ?>
                                                <?php if($halfReview==true): ?>
                                                <i class="fas fa-star-half-alt"></i>
                                                    <?php
                                                        $halfReview=false
                                                    ?>
                                                <?php else: ?>
                                                <i class="fal fa-star"></i>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                    </p>
                                <?php endif; ?>

                                <?php if($reviewQty == 0): ?>
                                    <p class="wsus__pro_rating">
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                    </p>
                                <?php endif; ?>

                                <a class="wsus__pro_name" href="<?php echo e(route('product-detail', $relatedProduct->slug)); ?>"><?php echo e($relatedProduct->short_name); ?></a>
                                <?php if($isCampaign): ?>
                                    <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f",$totalPrice)); ?></del></p>
                                <?php else: ?>
                                    <?php if($relatedProduct->offer_price == null): ?>
                                    <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></p>
                                    <?php else: ?>
                                    <p class="wsus__price"><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $relatedProduct->offer_price + $variantPrice)); ?> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></p>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <a class="add_cart" onclick="addToCartMainProduct('<?php echo e($relatedProduct->id); ?>')" href="javascript:;"><?php echo e(__('user.add to cart')); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <section class="product_popup_modal">
                    <div class="modal fade" id="productModalView-<?php echo e($relatedProduct->id); ?>" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                            class="far fa-times"></i></button>
                                    <div class="row">
                                        <div class="col-xl-6 col-12 col-sm-10 col-md-8 col-lg-6 m-auto display">
                                            <div class="wsus__quick_view_img">
                                                <?php if($relatedProduct->video_link): ?>
                                                    <?php
                                                        $video_id=explode("=",$relatedProduct->video_link);
                                                    ?>
                                                    <a class="venobox wsus__pro_det_video" data-autoplay="true" data-vbtype="video"
                                                    href="https://youtu.be/<?php echo e($video_id[1]); ?>">
                                                    <i class="fas fa-play"></i>
                                                </a>
                                                <?php endif; ?>

                                                <div class="row modal_slider">
                                                    <?php $__currentLoopData = $relatedProduct->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-xl-12">
                                                        <div class="modal_slider_img">
                                                            <img src="<?php echo e(asset($image->image)); ?>" alt="product" class="img-fluid w-100">
                                                        </div>
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-12 col-sm-12 col-md-12 col-lg-6">
                                            <div class="wsus__pro_details_text">
                                                <a class="title" href="<?php echo e(route('product-detail', $relatedProduct->slug)); ?>"><?php echo e($relatedProduct->name); ?></a>

                                                    <?php if($relatedProduct->qty == 0): ?>
                                                    <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.Out of Stock')); ?></span></p>
                                                    <?php else: ?>
                                                        <p class="wsus__stock_area"><span class="in_stock"><?php echo e(__('user.In stock')); ?>

                                                            <?php if($setting->show_product_qty == 1): ?>
                                                                </span> (<?php echo e($relatedProduct->qty); ?> <?php echo e(__('user.item')); ?>)
                                                            <?php endif; ?>
                                                        </p>
                                                    <?php endif; ?>


                                                <?php
                                                    $reviewQty = $relatedProduct->reviews->where('status',1)->count();
                                                    $totalReview = $relatedProduct->reviews->where('status',1)->sum('rating');

                                                    if ($reviewQty > 0) {
                                                        $average = $totalReview / $reviewQty;

                                                        $intAverage = intval($average);

                                                        $nextValue = $intAverage + 1;
                                                        $reviewPoint = $intAverage;
                                                        $halfReview=false;
                                                        if($intAverage < $average && $average < $nextValue){
                                                            $reviewPoint= $intAverage + 0.5;
                                                            $halfReview=true;
                                                        }
                                                    }
                                                ?>

                                                <?php
                                                    $variantPrice = 0;
                                                    $variants = $relatedProduct->variants->where('status', 1);
                                                    if($variants->count() != 0){
                                                        foreach ($variants as $variants_key => $variant) {
                                                            if($variant->variantItems->where('status',1)->count() != 0){
                                                                $item = $variant->variantItems->where('is_default',1)->first();
                                                                if($item){
                                                                    $variantPrice += $item->price;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    $isCampaign = false;
                                                    $today = date('Y-m-d H:i:s');
                                                    $campaign = App\Models\CampaignProduct::where(['status' => 1, 'product_id' => $relatedProduct->id])->first();
                                                    if($campaign){
                                                        $campaign = $campaign->campaign;
                                                        if($campaign->start_date <= $today &&  $today <= $campaign->end_date){
                                                            $isCampaign = true;
                                                        }
                                                        $campaignOffer = $campaign->offer;
                                                        $productPrice = $relatedProduct->price;
                                                        $campaignOfferPrice = ($campaignOffer / 100) * $productPrice;
                                                        $totalPrice = $relatedProduct->price;
                                                        $campaignOfferPrice = $totalPrice - $campaignOfferPrice;
                                                    }

                                                    $totalPrice = $relatedProduct->price;
                                                    if($relatedProduct->offer_price != null){
                                                        $offerPrice = $relatedProduct->offer_price;
                                                        $offer = $totalPrice - $offerPrice;
                                                        $percentage = ($offer * 100) / $totalPrice;
                                                        $percentage = round($percentage);
                                                    }


                                                ?>

                                                <?php if($isCampaign): ?>
                                                    <h4><?php echo e($currencySetting->currency_icon); ?> <span id="mainProductModalPrice-<?php echo e($relatedProduct->id); ?>"><?php echo e(sprintf("%.2f", $campaignOfferPrice + $variantPrice)); ?></span>  <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                <?php else: ?>
                                                    <?php if($relatedProduct->offer_price == null): ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($relatedProduct->id); ?>"><?php echo e(sprintf("%.2f", $totalPrice + $variantPrice)); ?></span></h4>
                                                    <?php else: ?>
                                                        <h4><?php echo e($currencySetting->currency_icon); ?><span id="mainProductModalPrice-<?php echo e($relatedProduct->id); ?>"><?php echo e(sprintf("%.2f", $relatedProduct->offer_price + $variantPrice)); ?></span> <del><?php echo e($currencySetting->currency_icon); ?><?php echo e(sprintf("%.2f", $totalPrice)); ?></del></h4>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <?php if($reviewQty > 0): ?>
                                                    <p class="review">
                                                        <?php for($i = 1; $i <=5; $i++): ?>
                                                            <?php if($i <= $reviewPoint): ?>
                                                                <i class="fas fa-star"></i>
                                                            <?php elseif($i> $reviewPoint ): ?>
                                                                <?php if($halfReview==true): ?>
                                                                <i class="fas fa-star-half-alt"></i>
                                                                    <?php
                                                                        $halfReview=false
                                                                    ?>
                                                                <?php else: ?>
                                                                <i class="fal fa-star"></i>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endfor; ?>
                                                        <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                                    </p>
                                                <?php endif; ?>

                                                <?php if($reviewQty == 0): ?>
                                                    <p class="review">
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <i class="fal fa-star"></i>
                                                        <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                                    </p>
                                                <?php endif; ?>

                                                <?php
                                                    $productPrice = 0;
                                                    if($isCampaign){
                                                        $productPrice = $campaignOfferPrice + $variantPrice;
                                                    }else{
                                                        if ($relatedProduct->offer_price == null) {
                                                            $productPrice = $totalPrice + $variantPrice;
                                                        }else {
                                                            $productPrice = $relatedProduct->offer_price + $variantPrice;
                                                        }
                                                    }
                                                ?>
                                                <form id="productModalFormId-<?php echo e($relatedProduct->id); ?>">
                                                <div class="wsus__quentity">
                                                    <h5><?php echo e(__('user.quantity')); ?> :</h5>
                                                    <div class="modal_btn">
                                                        <button onclick="productModalDecrement('<?php echo e($relatedProduct->id); ?>')" type="button" class="btn btn-danger btn-sm">-</button>
                                                        <input id="productModalQty-<?php echo e($relatedProduct->id); ?>" name="quantity"  readonly class="form-control" type="text" min="1" max="100" value="1" />
                                                        <button onclick="productModalIncrement('<?php echo e($relatedProduct->id); ?>', '<?php echo e($relatedProduct->qty); ?>')" type="button" class="btn btn-success btn-sm">+</button>
                                                    </div>
                                                    <h3 class="d-none"><?php echo e($currencySetting->currency_icon); ?><span id="productModalPrice-<?php echo e($relatedProduct->id); ?>"><?php echo e(sprintf("%.2f",$productPrice)); ?></span></h3>

                                                    <input type="hidden" name="product_id" value="<?php echo e($relatedProduct->id); ?>">
                                                    <input type="hidden" name="image" value="<?php echo e($relatedProduct->thumb_image); ?>">
                                                    <input type="hidden" name="slug" value="<?php echo e($relatedProduct->slug); ?>">

                                                </div>
                                                <?php
                                                    $productVariants = App\Models\ProductVariant::where(['status' => 1, 'product_id'=> $relatedProduct->id])->get();
                                                ?>
                                                <?php if($productVariants->count() != 0): ?>
                                                    <div class="wsus__selectbox">
                                                        <div class="row">
                                                            <?php $__currentLoopData = $productVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productVariant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php
                                                                    $items = App\Models\ProductVariantItem::orderBy('is_default','desc')->where(['product_variant_id' => $productVariant->id, 'product_id' => $relatedProduct->id])->get();
                                                                ?>
                                                                <?php if($items->count() != 0): ?>
                                                                    <div class="col-xl-6 col-sm-6 mb-3">
                                                                        <h5 class="mb-2"><?php echo e($productVariant->name); ?>:</h5>

                                                                        <input type="hidden" name="variants[]" value="<?php echo e($productVariant->id); ?>">
                                                                        <input type="hidden" name="variantNames[]" value="<?php echo e($productVariant->name); ?>">

                                                                        <select class="select_2 productModalVariant" name="items[]" data-product="<?php echo e($relatedProduct->id); ?>">
                                                                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>

                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <ul class="wsus__button_area">
                                                    <li><button type="button" onclick="addToCartInProductModal('<?php echo e($relatedProduct->id); ?>')" class="add_cart"><?php echo e(__('user.add to cart')); ?></button></li>
                                                    <li><a class="buy_now" href="javascript:;" onclick="addToBuyNow('<?php echo e($relatedProduct->id); ?>')"><?php echo e(__('user.buy now')); ?></a></li>
                                                    <li><a href="javascript:;" onclick="addToWishlist('<?php echo e($relatedProduct->id); ?>')"><i class="fal fa-heart"></i></a></li>
                                                    <li><a href="javascript:;" onclick="addToCompare('<?php echo e($relatedProduct->id); ?>')"><i class="far fa-random"></i></a></li>
                                                </ul>
                                            </form>
                                            <?php if($relatedProduct->sku): ?>
                                            <p class="brand_model"><span><?php echo e(__('user.Model')); ?> :</span> <?php echo e($relatedProduct->sku); ?></p>
                                            <?php endif; ?>

                                            <p class="brand_model"><span><?php echo e(__('user.Brand')); ?> :</span> <a href="<?php echo e(route('product',['brand' => $relatedProduct->brand->slug])); ?>"><?php echo e($relatedProduct->brand->name); ?></a></p>
                                            <p class="brand_model"><span><?php echo e(__('user.Category')); ?> :</span> <a href="<?php echo e(route('product',['category' => $relatedProduct->category->slug])); ?>"><?php echo e($relatedProduct->category->name); ?></a></p>
                                            <div class="wsus__pro_det_share d-none">
                                                <h5><?php echo e(__('user.share')); ?> :</h5>
                                                <ul class="d-flex">
                                                    <li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('product-detail', $relatedProduct->slug)); ?>&t=<?php echo e($relatedProduct->name); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                                    <li><a class="twitter" href="https://twitter.com/share?text=<?php echo e($relatedProduct->name); ?>&url=<?php echo e(route('product-detail', $relatedProduct->slug)); ?>"><i class="fab fa-twitter"></i></a></li>
                                                    <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('product-detail', $relatedProduct->slug)); ?>&title=<?php echo e($relatedProduct->name); ?>"><i class="fab fa-linkedin"></i></a></li>
                                                    <li><a class="pinterest" href="https://www.pinterest.com/pin/create/button/?description=<?php echo e($relatedProduct->name); ?>&media=&url=<?php echo e(route('product-detail', $relatedProduct->slug)); ?>"><i class="fab fa-pinterest-p"></i></a></li>
                                                </ul>
                                            </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>
    <?php endif; ?>
    <!--============================
        RELATED PRODUCT END
    ==============================-->


<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $(".productVariant").on("change",function(){
                calculateProductPrice();
            })

            $(".decrementProduct").on("click", function(){
                let qty = $(".product_qty").val();
                if(qty > 1){
                    qty = qty - 1;
                    $(".product_qty").val(qty);
                    calculateProductPrice();
                }
            })

            $(".incrementProduct").on("click", function(){
                let stock_qty = "<?php echo e($product->qty); ?>";

                let qty = $(".product_qty").val();
                if(parseInt(qty) < parseInt(stock_qty)){
                    qty = qty*1 + 1*1;
                    $(".product_qty").val(qty);
                    calculateProductPrice();
                }
            })

            $("#reportModalForm").on('submit', function(e){
                e.preventDefault();
                var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
                if(isDemo == 0){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                $.ajax({
                    type: 'post',
                    data: $('#reportModalForm').serialize(),
                    url: "<?php echo e(route('user.product-report')); ?>",
                    success: function (response) {
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#productReportModal").trigger("reset");
                            $("#productReportModal").modal('hide')
                        }
                        if(response.status == 0){
                            toastr.error(response.message)
                        }
                    },
                    error: function(err) {
                        alert('error')
                    }
                });
            })

            //start insert new cart item
            $("#shoppingCartForm").on("submit", function(e){
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    data: $('#shoppingCartForm').serialize(),
                    url: "<?php echo e(route('add-to-cart')); ?>",
                    success: function (response) {
                        if(response.status == 0){
                            toastr.error(response.message)
                        }
                        if(response.status == 1){
                            toastr.success(response.message)
                            $.ajax({
                                type: 'get',
                                url: "<?php echo e(route('load-sidebar-cart')); ?>",
                                success: function (response) {
                                   $("#load_sidebar_cart").html(response)
                                   $.ajax({
                                        type: 'get',
                                        url: "<?php echo e(route('get-cart-qty')); ?>",
                                        success: function (response) {
                                            $("#cartQty").text(response.qty);
                                        },
                                    });
                                },
                            });
                        }
                    },
                    error: function(response) {

                    }
                });
            })
            //start insert new cart item

            // buy now item
            $("#buyNowBtn").on("click", function(){
                $.ajax({
                    type: 'get',
                    data: $('#shoppingCartForm').serialize(),
                    url: "<?php echo e(route('add-to-cart')); ?>",
                    success: function (response) {
                        if(response.status == 0){
                            toastr.error(response.message)
                        }
                        if(response.status == 1){
                            window.location.href = "<?php echo e(route('cart')); ?>";
                            toastr.success(response.message)
                            $.ajax({
                                type: 'get',
                                url: "<?php echo e(route('load-sidebar-cart')); ?>",
                                success: function (response) {
                                   $("#load_sidebar_cart").html(response)
                                   $.ajax({
                                        type: 'get',
                                        url: "<?php echo e(route('get-cart-qty')); ?>",
                                        success: function (response) {
                                            $("#cartQty").text(response.qty);
                                        },
                                    });
                                },
                            });
                        }
                    },
                    error: function(response) {

                    }
                });
            })

            $("#reviewFormId").on('submit', function(e){
                e.preventDefault();

                var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
                if(isDemo == 0){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                $.ajax({
                    type: 'post',
                    data: $('#reviewFormId').serialize(),
                    url: "<?php echo e(route('user.store-product-review')); ?>",
                    success: function (response) {
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#reviewFormId").trigger("reset");
                        }
                        if(response.status == 0){
                            toastr.error(response.message)
                            $("#reviewFormId").trigger("reset");
                        }
                    },
                    error: function(response) {
                        if(response.responseJSON.errors.rating)toastr.error(response.responseJSON.errors.rating[0])
                        if(response.responseJSON.errors.review)toastr.error(response.responseJSON.errors.review[0])
                        if(!response.responseJSON.errors.rating || !response.responseJSON.errors.review){
                            toastr.error("<?php echo e(__('user.Please complete the recaptcha to submit the form')); ?>")
                        }
                    }
                });
            })

        });
    })(jQuery);

    function calculateProductPrice(){
        $.ajax({
            type: 'get',
            data: $('#shoppingCartForm').serialize(),
            url: "<?php echo e(route('calculate-product-price')); ?>",
            success: function (response) {
                let qty = $(".product_qty").val();
                let price = response.productPrice * qty;
                price = price.toFixed(2);
                $("#product_price").text(price);
                $("#mainProductPrice").text(price);
            },
            error: function(err) {
                alert('error')
            }
        });
    }

    function productReview(rating){
        $(".product_rat").each(function(){
            var product_rat = $(this).data('rating')
            if(product_rat > rating){
                $(this).removeClass('fas fa-star').addClass('fal fa-star');
            }else{
                $(this).removeClass('fal fa-star').addClass('fas fa-star');
            }
        })
        $("#product_rating").val(rating);
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/product_detail.blade.php ENDPATH**/ ?>