
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seoSetting->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seoSetting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>
    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e($contact ? asset($contact->banner) : ''); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.contact us')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <li><a href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('user.Contact us')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
        CONTACT PAGE START
    ==============================-->
    <section id="wsus__contact">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__contact_header">
                        <h4><?php echo e($contact ? $contact->title : ''); ?></h4>
                        <p><?php echo e($contact ? $contact->description : ''); ?></p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-4 col-sm-12 col-lg-4">
                    <div class="wsus__contact_single">
                        <i class="fal fa-envelope"></i>
                        <h5><?php echo e(__('user.mail address')); ?></h5>
                        <?php if($contact): ?>
                        <a href="mailto:<?php echo e($contact->email); ?>"><?php echo e($contact->email); ?></a>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="col-xl-4 col-sm-12 col-lg-4">
                    <div class="wsus__contact_single">
                        <i class="far fa-phone-alt"></i>
                        <h5><?php echo e(__('user.phone number')); ?></h5>
                        <?php if($contact): ?>
                        <a href="macallto:<?php echo e($contact->phone); ?>"><?php echo e($contact->phone); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-4 col-sm-12 col-lg-4">
                    <div class="wsus__contact_single">
                        <i class="fal fa-map-marker-alt"></i>
                        <h5><?php echo e(__('user.contact address')); ?></h5>
                        <?php if($contact): ?>
                        <a href="javascript::void()"><?php echo e($contact->address); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-12">
                    <div class="wsus__contact_question">
                        <h5><?php echo e(__('user.Send Us a Message')); ?></h5>
                        <form method="POST" action="<?php echo e(route('send-contact-message')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-6 col-md-6">
                                    <div class="wsus__con_form_single">
                                        <input type="text" name="name" placeholder="<?php echo e(__('user.Name')); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-6">
                                    <div class="wsus__con_form_single">
                                        <input type="email" name="email"  placeholder="<?php echo e(__('user.Email')); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-6">
                                    <div class="wsus__con_form_single">
                                        <input type="text" name="phone"  placeholder="<?php echo e(__('user.Phone')); ?>">
                                    </div>
                                </div>

                                <div class="col-xl-6 col-md-6">
                                    <div class="wsus__con_form_single">
                                        <input type="text" placeholder="<?php echo e(__('user.Subject')); ?>" name="subject">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="wsus__con_form_single">
                                        <textarea cols="3" rows="5" placeholder="<?php echo e(__('user.Message')); ?>" name="message"></textarea>
                                    </div>
                                </div>
                            </div>

                            <?php if($recaptchaSetting->status==1): ?>
                                <div class="col-xl-12">
                                    <div class="wsus__single_com mb-3">
                                        <div class="g-recaptcha" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="col-12">
                                <button type="submit" class="common_btn"><?php echo e(__('user.send now')); ?></button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="col-12">
                    <?php if($contact): ?>
                    <div class="wsus__con_map">
                        <?php echo $contact->map; ?>

                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </section>
    <!--============================
        CONTACT PAGE END
    ==============================-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/contact_us.blade.php ENDPATH**/ ?>