
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Blog')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Edit Blog')); ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.blog.index')); ?>"><?php echo e(__('admin.Blog')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Edit Blog')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.blog.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Blog')); ?></a>
            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.blog.update',$blog->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Thumbnail Image Preview')); ?></label>
                                    <div>
                                        <img id="preview-img" class="admin-img" src="<?php echo e(asset($blog->image)); ?>" alt="">
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.New Thumbnail Image')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control-file"  name="image" onchange="previewThumnailImage(event)">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Banner Image Preview')); ?></label>
                                    <div>
                                        <img id="preview-banner-img" class="admin-banner-img" src="<?php echo e(asset($blog->banner_image)); ?>" alt="">
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.New Banner Image')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control-file"  name="banner_image" onchange="previewBannerImage(event)">
                                </div>


                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Title')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="title" class="form-control"  name="title" value="<?php echo e($blog->title); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Slug')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="slug" class="form-control"  name="slug" value="<?php echo e($blog->slug); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Category')); ?> <span class="text-danger">*</span></label>
                                    <select name="category" class="form-control select2" id="category">
                                        <option value=""><?php echo e(__('admin.Select Category')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($category->id == $blog->blog_category_id ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="description" id="" cols="30" rows="10" class="summernote"><?php echo e($blog->description); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Show Homepage ?')); ?>  <span class="text-danger">*</span></label>
                                    <select name="show_homepage" class="form-control">
                                        <option <?php echo e($blog->show_homepage == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.No')); ?></option>
                                        <option <?php echo e($blog->show_homepage == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Yes')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option <?php echo e($blog->status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option <?php echo e($blog->status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Title')); ?></label>
                                   <input type="text" class="form-control" name="seo_title" value="<?php echo e($blog->seo_title); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Description')); ?></label>
                                    <textarea name="seo_description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($blog->seo_description); ?></textarea>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $("#title").on("focusout",function(e){
                $("#slug").val(convertToSlug($(this).val()));
            })
        });
    })(jQuery);

    function convertToSlug(Text)
        {
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g,'')
                .replace(/ +/g,'-');
        }

    function previewThumnailImage(event) {
        var reader = new FileReader();

        reader.readAsDataURL(event.target.files[0]);
    };

    function previewBannerImage(event) {
        var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('preview-img');
            output.src = reader.result;
        }
        reader.readAsDataURL(event.target.files[0]);
    };

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/edit_blog.blade.php ENDPATH**/ ?>