
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seoSetting->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seoSetting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Blog')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('blog')); ?>"><?php echo e(__('user.Blog')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
        BLOGS PAGE START
    ==============================-->
    <section id="wsus__blogs">
        <div class="container">
            <div class="row">
                <?php
                    $colorId=1;
                ?>
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    if($index %4 ==0){
                        $colorId=1;
                    }

                    $color="";
                    if($colorId==1){
                        $color="blue";
                    }else if($colorId==2){
                        $color="red";
                    }else if($colorId==3){
                        $color="orange";
                    }else if($colorId==4){
                        $color="green";
                    }
                ?>
                    <div class="col-xl-4 col-sm-6 col-lg-4 col-xxl-3">
                        <div class="wsus__single_blog">
                            <a class="wsus__blog_img" href="#">
                                <img src="<?php echo e(asset($blog->image)); ?>" alt="blog" class="img-fluid w-100">
                            </a>
                            <a class="blog_top <?php echo e($color); ?>" href="<?php echo e(route('blog-by-category', $blog->category->slug)); ?>"><?php echo e($blog->category->name); ?></a>
                            <div class="wsus__blog_text">
                                <div class="wsus__blog_text_center">
                                    <a href="<?php echo e(route('blog-detail',$blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                                    <p class="date"><span><?php echo e($blog->created_at->format('d F, Y')); ?></span> <?php echo e(__('user.Hosted by')); ?> <?php echo e($blog->admin->name); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                        $colorId ++;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-12">
                    <?php echo e($blogs->links('custom_paginator')); ?>

                </div>
            </div>
            <?php if($blogs->count() == 0): ?>
                <div class="row">
                    <div class="col-12 text-center">
                        <h2 class="text-danger text-center"><?php echo e(__('user.Blog Not Found')); ?></h2>
                    </div>
                </div>
            <?php endif; ?>


        </div>
    </section>
    <!--============================
        BLOGS PAGE END
    ==============================-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/blog.blade.php ENDPATH**/ ?>