
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Return Policy')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Create Return Policy')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.return-policy.index')); ?>"><?php echo e(__('admin.Return Policy')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Create Return Policy')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.return-policy.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Return Policy')); ?></a>
            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.return-policy.update',$returnPolicy->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Title')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="name" class="form-control"  name="title" value="<?php echo e($returnPolicy->title); ?>">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Details')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="details" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($returnPolicy->details); ?></textarea>
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option <?php echo e($returnPolicy->status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option <?php echo e($returnPolicy->status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/edit_return_policy.blade.php ENDPATH**/ ?>