
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Payment Methods')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Payment Methods')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
            </div>
          </div>

        <div class="section-body">
            <div class="row mt-4">
                <div class="col">
                    <div class="card">
                        <div class="card-header">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-3">
                                    <ul class="nav nav-pills flex-column" id="myTab4" role="tablist">


                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link active" id="paypal-tab" data-toggle="tab" href="#paypalTab" role="tab" aria-controls="paypalTab" aria-selected="true"><?php echo e(__('admin.Paypal')); ?></a>
                                        </li>

                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="stripe-tab" data-toggle="tab" href="#stripeTab" role="tab" aria-controls="stripeTab" aria-selected="true"><?php echo e(__('admin.Stripe')); ?></a>
                                        </li>

                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="razorpay-tab" data-toggle="tab" href="#razorpayTab" role="tab" aria-controls="razorpayTab" aria-selected="true"><?php echo e(__('admin.Razorpay')); ?></a>
                                        </li>

                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="flutterwave-tab" data-toggle="tab" href="#flutterwaveTab" role="tab" aria-controls="flutterwaveTab" aria-selected="true"><?php echo e(__('admin.Flutterwave')); ?></a>
                                        </li>



                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="mollie-tab" data-toggle="tab" href="#mollieTab" role="tab" aria-controls="mollieTab" aria-selected="true"><?php echo e(__('admin.Mollie')); ?></a>
                                        </li>

                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="pay-stack-tab" data-toggle="tab" href="#payStackTab" role="tab" aria-controls="payStackTab" aria-selected="true"><?php echo e(__('admin.PayStack')); ?></a>
                                        </li>

                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="instamojo-tab" data-toggle="tab" href="#instamojoTab" role="tab" aria-controls="instamojoTab" aria-selected="true"><?php echo e(__('admin.Instamojo')); ?></a>
                                        </li>

                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="paymongo-tab" data-toggle="tab" href="#paymongoTab" role="tab" aria-controls="paymongoTab" aria-selected="true"><?php echo e(__('admin.Paymongo')); ?></a>
                                        </li>



                                        <li class="nav-item border rounded mb-1">
                                            <a class="nav-link" id="bank-account-tab" data-toggle="tab" href="#bankAccountTab" role="tab" aria-controls="bankAccountTab" aria-selected="true"><?php echo e(__('admin.Bank Account')); ?></a>
                                        </li>
                                        <?php if($bank): ?>
                                            <li class="nav-item border rounded mb-1">
                                                <a class="nav-link" id="cash-tab" data-toggle="tab" href="#cashTab" role="tab" aria-controls="cashTab" aria-selected="true"><?php echo e(__('admin.Cash On Deliver')); ?></a>
                                            </li>
                                        <?php endif; ?>


                                    </ul>
                                </div>
                                <div class="col-12 col-sm-12 col-md-9">
                                    <div class="border rounded">
                                        <div class="tab-content no-padding" id="settingsContent">

                                            <div class="tab-pane fade show active" id="paypalTab" role="tabpanel" aria-labelledby="paypal-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-paypal')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Paypal Status')); ?></label>
                                                                <div>
                                                                    <?php if($paypal->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Account Mode')); ?></label>
                                                                <select name="account_mode" id="account_mode" class="form-control">
                                                                    <option <?php echo e($paypal->account_mode == 'live' ? 'selected' : ''); ?> value="live"><?php echo e(__('admin.Live')); ?></option>
                                                                    <option <?php echo e($paypal->account_mode == 'sandbox' ? 'selected' : ''); ?> value="sandbox"><?php echo e(__('admin.Sandbox')); ?></option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paypal->country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paypal->currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency rate')); ?> ( <?php echo e(__('admin.Per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="currency_rate" value="<?php echo e($paypal->currency_rate); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Paypal Client Id')); ?></label>
                                                                <input type="text" class="form-control" name="paypal_client_id" value="<?php echo e($paypal->client_id); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Paypal Secret Key')); ?></label>
                                                                <input type="text" class="form-control" name="paypal_secret_key" value="<?php echo e($paypal->secret_id); ?>">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="stripeTab" role="tabpanel" aria-labelledby="stripe-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-stripe')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Stripe Status')); ?></label>
                                                                <div>
                                                                    <?php if($stripe->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($stripe->country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($stripe->currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency rate')); ?> ( <?php echo e(__('admin.per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="currency_rate" value="<?php echo e($stripe->currency_rate); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Stripe Key')); ?></label>
                                                                <input type="text" class="form-control" name="stripe_key" value="<?php echo e($stripe->stripe_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Stripe Secret')); ?></label>
                                                                <input type="text" class="form-control" name="stripe_secret" value="<?php echo e($stripe->stripe_secret); ?>">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="razorpayTab" role="tabpanel" aria-labelledby="razorpay-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-razorpay')); ?>" method="POST" enctype="multipart/form-data">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Razorpay Status')); ?></label>
                                                                <div>
                                                                    <?php if($razorpay->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Razorpay Key')); ?></label>
                                                                <input type="text" class="form-control" name="razorpay_key" value="<?php echo e($razorpay->key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Razorpay Secret Key')); ?></label>
                                                                <input type="text" class="form-control" name="razorpay_secret" value="<?php echo e($razorpay->secret_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Name')); ?></label>
                                                                <input type="text" class="form-control" name="name" value="<?php echo e($razorpay->name); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Description')); ?></label>
                                                                <input type="text" class="form-control" name="description" value="<?php echo e($razorpay->description); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($razorpay->country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($razorpay->currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Rate')); ?> (<?php echo e(__('admin.per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="currency_rate" value="<?php echo e($razorpay->currency_rate); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Current Image')); ?></label>
                                                                <div>
                                                                    <img src="<?php echo e(asset($razorpay->image)); ?>" width="200px" alt="">
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.New Image')); ?></label>
                                                                <input type="file" class="form-control-file" name="image">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Theme Color')); ?></label>
                                                                <input type="color" value="<?php echo e($razorpay->color); ?>" class="form-control" name="theme_color">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="flutterwaveTab" role="tabpanel" aria-labelledby="flutterwave-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-flutterwave')); ?>" method="POST" enctype="multipart/form-data">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Flutterwave Status')); ?></label>
                                                                <div>
                                                                    <?php if($flutterwave->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Public Key')); ?></label>
                                                                <input type="text" class="form-control" name="public_key" value="<?php echo e($flutterwave->public_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Secret Key')); ?></label>
                                                                <input type="text" class="form-control" name="secret_key" value="<?php echo e($flutterwave->secret_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Title')); ?></label>
                                                                <input type="text" class="form-control" name="title" value="<?php echo e($flutterwave->title); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($flutterwave->country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($flutterwave->currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Rate')); ?> (<?php echo e(__('admin.Per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="currency_rate" value="<?php echo e($flutterwave->currency_rate); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Current Image')); ?></label>
                                                                <div>
                                                                    <img src="<?php echo e(asset($flutterwave->logo)); ?>" width="200px" alt="">
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.New Image')); ?></label>
                                                                <input type="file" class="form-control-file" name="image">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="mollieTab" role="tabpanel" aria-labelledby="mollie-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-mollie')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Mollie Status')); ?></label>
                                                                <div>
                                                                    <?php if($paystackAndMollie->mollie_status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Mollie Key')); ?></label>
                                                                <input type="text" class="form-control" name="mollie_key" value="<?php echo e($paystackAndMollie->mollie_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="mollie_country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paystackAndMollie->mollie_country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="mollie_currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paystackAndMollie->mollie_currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Rate')); ?> (<?php echo e(__('admin.per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="mollie_currency_rate" value="<?php echo e($paystackAndMollie->mollie_currency_rate); ?>">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="payStackTab" role="tabpanel" aria-labelledby="pay-stack-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-paystack')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.PayStack Status')); ?></label>
                                                                <div>
                                                                    <?php if($paystackAndMollie->paystack_status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Public Key')); ?></label>
                                                                <input type="text" name="paystack_public_key" class="form-control" value="<?php echo e($paystackAndMollie->paystack_public_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Secret Key')); ?></label>
                                                                <input type="text" name="paystack_secret_key" class="form-control" value="<?php echo e($paystackAndMollie->paystack_secret_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="paystack_country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paystackAndMollie->paystack_country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="paystack_currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paystackAndMollie->paystack_currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Rate')); ?> (<?php echo e(__('admin.per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="paystack_currency_rate" value="<?php echo e($paystackAndMollie->paystack_currency_rate); ?>">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="instamojoTab" role="tabpanel" aria-labelledby="instamojo-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-instamojo')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Instamojo Status')); ?></label>
                                                                <div>
                                                                    <?php if($instamojo->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Account Mode')); ?></label>
                                                                <select name="account_mode" id="account_mode" class="form-control">
                                                                    <option value="Sandbox"><?php echo e(__('admin.Sandbox')); ?></option>
                                                                    <option value="Live"><?php echo e(__('admin.Live')); ?></option>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Api Key')); ?></label>
                                                                <input type="text" name="api_key" class="form-control" value="<?php echo e($instamojo->api_key); ?>">
                                                            </div>



                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Auth Token')); ?></label>
                                                                <input type="text" name="auth_token" class="form-control" value="<?php echo e($instamojo->auth_token); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.INR Currency Rate')); ?> (<?php echo e(__('admin.per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="currency_rate" value="<?php echo e($instamojo->currency_rate); ?>">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="paymongoTab" role="tabpanel" aria-labelledby="paymongo-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-paymongo')); ?>" method="POST" enctype="multipart/form-data">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Paymongo Status')); ?></label>
                                                                <div>
                                                                    <?php if($paymongo->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Public Key')); ?></label>
                                                                <input type="text" class="form-control" name="public_key" value="<?php echo e($paymongo->public_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Secret Key')); ?></label>
                                                                <input type="text" class="form-control" name="secret_key" value="<?php echo e($paymongo->secret_key); ?>">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Country Name')); ?></label>
                                                                <select name="country_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Country')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $countires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paymongo->country_code == $country->code ? 'selected' : ''); ?> value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Name')); ?></label>
                                                                <select name="currency_name" id="" class="form-control select2">
                                                                    <option value=""><?php echo e(__('admin.Select Currency')); ?>

                                                                  </option>
                                                                  <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                  <option <?php echo e($paymongo->currency_code == $currency->code ? 'selected' : ''); ?> value="<?php echo e($currency->code); ?>"><?php echo e($currency->name); ?>

                                                                  </option>
                                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Currency Rate')); ?> (<?php echo e(__('admin.Per')); ?> <?php echo e($setting->currency_name); ?>)</label>
                                                                <input type="text" class="form-control" name="currency_rate" value="<?php echo e($paymongo->currency_rate); ?>">
                                                            </div>

                                                            <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>



                                            <div class="tab-pane fade" id="bankAccountTab" role="tabpanel" aria-labelledby="bank-account-tab">
                                                <div class="card m-0">
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.update-bank')); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Bank Payment Status')); ?></label>
                                                                <div>
                                                                    <?php if($bank->status == 1): ?>
                                                                        <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        <?php else: ?>
                                                                        <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>

                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Account Information')); ?></label>
                                                                <textarea name="account_info" id="" cols="30" rows="10" class="text-area-5 form-control"><?php echo e($bank->account_info); ?></textarea>
                                                            </div>

                                                            <button class="btn btn-primary">Update</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php if($bank): ?>
                                                <div class="tab-pane fade" id="cashTab" role="tabpanel" aria-labelledby="cash-tab">
                                                    <div class="card m-0">
                                                        <div class="card-body">
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('admin.Cash on delivery Status')); ?></label>
                                                                <div>
                                                                    <?php if($bank->cash_on_delivery_status == 1): ?>
                                                                        <a onclick="changeCashOnDeliveryStatus()" href="javascript:;">
                                                                            <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        </a>
                                                                        <?php else: ?>
                                                                        <a onclick="changeCashOnDeliveryStatus()" href="javascript:;">
                                                                            <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Enable')); ?>" data-off="<?php echo e(__('admin.Disable')); ?>" data-onstyle="success" data-offstyle="danger" name="status">
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </section>
      </div>

      <script>
        function changeCashOnDeliveryStatus(id){
            var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
            if(isDemo == 0){
                toastr.error('This Is Demo Version. You Can Not Change Anything');
                return;
            }
            $.ajax({
                type:"put",
                data: { _token : '<?php echo e(csrf_token()); ?>' },
                url: "<?php echo e(route('admin.update-cash-on-delivery')); ?>",
                success:function(response){
                    toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/payment_method.blade.php ENDPATH**/ ?>