
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Dashboard')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
<!-- Main Content -->
<div class="main-content">
    <section class="section">
      <div class="section-header">
        <h1><?php echo e(__('admin.Dashbaord')); ?></h1>
      </div>

      <div class="section-body">
        <div class="row">
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Today Order')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($todayOrders->count()); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Today Pending Order')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($todayOrders->where('order_status',0)->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Order')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($totalOrders->count()); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Pending Order')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($totalOrders->where('order_status',0)->count()); ?>

                  </div>
                </div>
              </div>
            </div>


            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-warning">
                  <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Declined Order')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($totalOrders->where('order_status',4)->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-warning">
                  <i class="fas fa-shopping-cart"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Complete Order')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($totalOrders->where('order_status',3)->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-warning">
                  <i class="far fa-newspaper"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Today Earning')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($setting->currency_icon); ?><?php echo e(round($todayOrders->sum('amount_real_currency'),2)); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-warning">
                  <i class="far fa-newspaper"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Today Pending Earning')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($setting->currency_icon); ?><?php echo e(round($todayOrders->where('payment_status',0)->sum('amount_real_currency'),2)); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-newspaper"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.This month Earning')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($setting->currency_icon); ?><?php echo e(round($monthlyOrders->sum('amount_real_currency'),2)); ?>

                  </div>
                </div>
              </div>
            </div>



            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-newspaper"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.This Year Earning')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($setting->currency_icon); ?><?php echo e(round($yearlyOrders->sum('amount_real_currency'),2)); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-newspaper"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Earning')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($setting->currency_icon); ?><?php echo e(round($totalOrders->sum('amount_real_currency'),2)); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="fas fa-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Today Product Sale')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($todayOrders->where('order_status',3)->sum('product_qty')); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-danger">
                  <i class="fas fa-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.This Month Product Sale')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($monthlyOrders->where('order_status',3)->sum('product_qty')); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-danger">
                  <i class="fas fa-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.This Year Product Sale')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($yearlyOrders->where('order_status',3)->sum('product_qty')); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-danger">
                  <i class="fas fa-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Product Sale')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($totalOrders->where('order_status',3)->sum('product_qty')); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-danger">
                  <i class="far fa-check-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Product')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($products->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-check-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Product Report')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($reports->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-check-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Product Review')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($reviews->count()); ?>

                  </div>
                </div>
              </div>
            </div>


            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-user"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Seller')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($sellers->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                  <i class="far fa-user"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total User')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($users->count()); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="far fa-user"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Subscriber')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($subscribers->count()); ?>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="far fa-check-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Blog')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($blogs->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="far fa-check-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Product Category')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($categories->count()); ?>

                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
              <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                  <i class="far fa-check-circle"></i>
                </div>
                <div class="card-wrap">
                  <div class="card-header">
                    <h4><?php echo e(__('admin.Total Brand')); ?></h4>
                  </div>
                  <div class="card-body">
                    <?php echo e($brands->count()); ?>

                  </div>
                </div>
              </div>
            </div>

          </div>
      </div>

      <div class="section-body">
        <div class="row mt-4">
            <div class="col">
              <div class="card">
                  <div class="card-header">
                    <h3><?php echo e(__('admin.Today New Order')); ?></h3>
                  </div>
                <div class="card-body">
                  <div class="table-responsive table-invoice">
                    <table class="table table-striped" id="dataTable">
                        <thead>
                            <tr>
                                <th width="5%"><?php echo e(__('admin.SN')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Customer')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Order Id')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Date')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Quantity')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Amount')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Order Status')); ?></th>
                                <th width="10%"><?php echo e(__('admin.Payment')); ?></th>
                                <th width="15%"><?php echo e(__('admin.Action')); ?></th>
                              </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $todayOrders->where('order_status',0); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$index); ?></td>
                                    <td><?php echo e($order->user->name); ?></td>
                                    <td><?php echo e($order->order_id); ?></td>
                                    <td><?php echo e($order->created_at->format('d F, Y')); ?></td>
                                    <td><?php echo e($order->product_qty); ?></td>
                                    <td><?php echo e($setting->currency_icon); ?><?php echo e($order->amount_real_currency); ?></td>
                                    <td>
                                        <?php if($order->order_status == 1): ?>
                                        <span class="badge badge-success"><?php echo e(__('admin.Pregress')); ?> </span>
                                        <?php elseif($order->order_status == 2): ?>
                                        <span class="badge badge-success"><?php echo e(__('admin.Delivered')); ?> </span>
                                        <?php elseif($order->order_status == 3): ?>
                                        <span class="badge badge-success"><?php echo e(__('admin.Completed')); ?></span>
                                        <?php elseif($order->order_status == 4): ?>
                                        <span class="badge badge-danger"><?php echo e(__('admin.Declined')); ?></span>
                                        <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e(__('admin.Pending')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($order->payment_status == 1): ?>
                                        <span class="badge badge-success"><?php echo e(__('admin.success')); ?> </span>
                                        <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e(__('admin.Pending')); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <td>

                                    <a href="<?php echo e(route('admin.order-show',$order->id)); ?>" class="btn btn-primary btn-sm"><i class="fa fa-eye" aria-hidden="true"></i></a>

                                    <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($order->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>

                                    <a href="javascript:;" data-toggle="modal" data-target="#orderModalId-<?php echo e($order->id); ?>" class="btn btn-warning btn-sm"><i class="fas fa-truck" aria-hidden="true"></i></a>
                                    </td>
                                </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
      </div>
    </section>
  </div>

   <!-- Modal -->
   <?php $__currentLoopData = $todayOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
   <div class="modal fade" id="orderModalId-<?php echo e($order->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
       <div class="modal-dialog" role="document">
           <div class="modal-content">
                   <div class="modal-header">
                           <h5 class="modal-title"><?php echo e(__('admin.Order Status')); ?></h5>
                               <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                   <span aria-hidden="true">&times;</span>
                               </button>
                       </div>
               <div class="modal-body">
                   <div class="container-fluid">
                       <form action="<?php echo e(route('admin.update-order-status',$order->id)); ?>" method="POST">
                         <?php echo method_field('PUT'); ?>
                           <?php echo csrf_field(); ?>
                           <div class="form-group">
                               <label for=""><?php echo e(__('admin.Payment')); ?></label>
                               <select name="payment_status" id="" class="form-control">
                                   <option <?php echo e($order->payment_status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Pending')); ?></option>
                                   <option <?php echo e($order->payment_status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Success')); ?></option>
                               </select>
                           </div>
                           <div class="form-group">
                               <label for=""><?php echo e(__('admin.Order')); ?></label>
                               <select name="order_status" id="" class="form-control">
                                 <option <?php echo e($order->order_status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Pending')); ?></option>
                                 <option <?php echo e($order->order_status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.In Progress')); ?></option>
                                 <option <?php echo e($order->order_status == 2 ? 'selected' : ''); ?>  value="2"><?php echo e(__('admin.Delivered')); ?></option>
                                 <option <?php echo e($order->order_status == 3 ? 'selected' : ''); ?> value="3"><?php echo e(__('admin.Completed')); ?></option>
                                 <option <?php echo e($order->order_status == 4 ? 'selected' : ''); ?> value="4"><?php echo e(__('admin.Declined')); ?></option>
                               </select>
                           </div>


                   </div>
               </div>
               <div class="modal-footer">
                   <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                   <button type="submit" class="btn btn-primary"><?php echo e(__('admin.Update Status')); ?></button>
               </div>
             </form>
           </div>
       </div>
   </div>

   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

   <script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/delete-order/")); ?>'+"/"+id)
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>