
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seoSetting->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seoSetting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Campaign')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('campaign')); ?>"><?php echo e(__('user.campaign')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->


    <!--============================
        DAILY DEALS START
    ==============================-->
    <section id="wsus__daily_deals">
        <div class="container">
            <div class="row">
                <?php if($campaigns->count() > 0): ?>
                    <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-sm-6 col-lg-4">
                        <div class="wsus__daily_deals_single">
                            <div class="wsus__daily_deals_single_img">
                            <a class="link_img" href="<?php echo e(route('campaign-detail',$campaign->slug)); ?>"> <img src="<?php echo e(asset($campaign->image)); ?>" alt="offer" class="img-fluid w-100"></a>
                                <p><?php echo e($campaign->title); ?></p>
                                <?php
                                    $today = date('Y-m-d H:i:s');
                                ?>
                                <?php if($campaign->start_date <= $today &&  $today <= $campaign->end_date): ?>
                                    <a class="blue" href="<?php echo e(route('campaign-detail',$campaign->slug)); ?>"><?php echo e(__('user.live now')); ?></a>
                                <?php elseif($campaign->start_date > $today &&  $today < $campaign->end_date): ?>
                                    <a class="live" href="<?php echo e(route('campaign-detail',$campaign->slug)); ?>"><?php echo e(__('user.Upcoming')); ?></a>
                                <?php else: ?>
                                <a class="live" href="<?php echo e(route('campaign-detail',$campaign->slug)); ?>"><?php echo e(__('user.Expired')); ?></a>
                                <?php endif; ?>

                            </div>
                            <div class="wsus__daily_deals_text">
                                <a class="deals_title" href="<?php echo e(route('campaign-detail',$campaign->slug)); ?>"><?php echo e($campaign->name); ?></a>
                                <p><?php echo e(__('user.sale start date')); ?>: <?php echo e(date('d F Y', strtotime($campaign->start_date))); ?></p>
                                <p><?php echo e(__('user.sale end date')); ?>: <?php echo e(date('d F Y', strtotime($campaign->end_date))); ?></p>
                                <a class="common_btn" href="<?php echo e(route('campaign-detail',$campaign->slug)); ?>"><?php echo e(__('user.view deals')); ?></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-12 text-center">
                        <h3 class="text-danger"><?php echo e(__('user.Campaign not found')); ?></h3>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </section>
    <!--============================
        DAILY DEALS END
    ==============================-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/campaign.blade.php ENDPATH**/ ?>