
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Popular Blog')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Popular Blog')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.blog.index')); ?>"><?php echo e(__('admin.Blogs')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Popular Blog')); ?></div>
            </div>
          </div>


        <div class="section-body">
            <div class="col">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.popular-blog.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for=""><?php echo e(__('admin.Blog')); ?></label>
                                <select name="blog_id" id="" class="form-control select2" required>
                                    <option value=""><?php echo e(__('admin.Select Blog')); ?></option>
                                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($blog->id); ?>"><?php echo e($blog->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <button class="btn btn-primary"><?php echo e(__('admin.Save')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

          <div class="section-body">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th width="5%"><?php echo e(__('admin.SN')); ?></th>
                                    <th width="30%"><?php echo e(__('admin.Blog')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Category')); ?></th>
                                    <th width="10%"><?php echo e(__('admin.Image')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Status')); ?></th>
                                    <th width="15%"><?php echo e(__('admin.Action')); ?></th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $popularBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $popularBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><?php echo e($popularBlog->blog->title); ?></td>
                                        <td><?php echo e($popularBlog->blog->category->name); ?></td>
                                        <td><img src="<?php echo e(asset($popularBlog->blog->image)); ?>" width="80px" class="rounded-circle" alt=""></td>
                                        <td>
                                            <?php if($popularBlog->status == 1): ?>
                                            <a href="javascript:;" onclick="changePopularBlogStatus(<?php echo e($popularBlog->id); ?>)">
                                                <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.Inactive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>

                                            <?php else: ?>
                                            <a href="javascript:;" onclick="changePopularBlogStatus(<?php echo e($popularBlog->id); ?>)">
                                                <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="<?php echo e(__('admin.Active')); ?>" data-off="<?php echo e(__('admin.Inactive')); ?>" data-onstyle="success" data-offstyle="danger">
                                            </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                        <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($popularBlog->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                    </td>

                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/popular-blog/")); ?>'+"/"+id)
    }
    function changePopularBlogStatus(id){
        var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '<?php echo e(csrf_token()); ?>' },
            url:"<?php echo e(url('/admin/popular-blog-status/')); ?>"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){
                console.log(err);

            }
        })
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/popular_blog.blade.php ENDPATH**/ ?>