
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seller->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seller->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e($seller->shop_name); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('sellers')); ?>"><?php echo e(__('user.Seller')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e($seller->shop_name); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->

    <!--============================
      VENDORS DETAILA START
    ==============================-->
    <section id="wsus__product_page" class="wsus__vendor_details_page">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="wsus__pro_page_bammer vendor_det_banner">
                        <img src="<?php echo e(asset($seller->banner_image)); ?>" alt="banner" class="img-fluid w-100">
                        <div class="wsus__pro_page_bammer_text wsus__vendor_det_banner_text">
                            <div class="wsus__vendor_text_center">
                                <h4><?php echo e($seller->shop_name); ?></h4>

                                <?php
                                    if ($reviewQty > 0) {
                                        $average = $totalReview / $reviewQty;
                                        $intAverage = intval($average);
                                        $nextValue = $intAverage + 1;
                                        $reviewPoint = $intAverage;
                                        $halfReview=false;
                                        if($intAverage < $average && $average < $nextValue){
                                            $reviewPoint= $intAverage + 0.5;
                                            $halfReview=true;
                                        }
                                    }
                                ?>

                                <?php if($reviewQty > 0): ?>
                                    <p class="wsus__vendor_rating">
                                        <?php for($i = 1; $i <=5; $i++): ?>
                                            <?php if($i <= $reviewPoint): ?>
                                                <i class="fas fa-star"></i>
                                            <?php elseif($i> $reviewPoint ): ?>
                                                <?php if($halfReview==true): ?>
                                                <i class="fas fa-star-half-alt"></i>
                                                    <?php
                                                        $halfReview=false
                                                    ?>
                                                <?php else: ?>
                                                <i class="fal fa-star"></i>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                    </p>
                                <?php endif; ?>

                                <?php if($reviewQty == 0): ?>
                                    <p class="wsus__vendor_rating">
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                    </p>
                                <?php endif; ?>

                                <a href="callto:<?php echo e($seller->phone); ?>"><i class="far fa-phone-alt"></i> <?php echo e($seller->phone); ?></a>
                                <a href="mailto:<?php echo e($seller->email); ?>"><i class="far fa-envelope"></i> <?php echo e($seller->email); ?></a>
                                <p class="wsus__vendor_location"><i class="fal fa-map-marker-alt"></i> <?php echo e($seller->address); ?> </p>

                                <?php
                                    $open_at = $seller->open_at;
                                    $closed_at = $seller->closed_at;
                                    $current_time =date('h:i');
                                    $socialLinks = $seller->socialLinks;
                                ?>

                                <?php if($open_at >= $current_time && $current_time <= $closed_at): ?>
                                    <p class="wsus__open_store"><i class="fab fa-shopify"></i> <?php echo e(__('user.store open')); ?></p>
                                <?php else: ?>
                                    <p class="wsus__open_store"><i class="fab fa-shopify"></i> <?php echo e(__('user.store Closed')); ?></p>
                                <?php endif; ?>

                                <?php if($socialLinks->count() > 0): ?>
                                    <ul class="d-flex">
                                        <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a class="facebook" href="<?php echo e($socialLink->link); ?>"><i class="<?php echo e($socialLink->icon); ?>"></i></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-lg-4">
                    <div class="wsus__sidebar_filter ">
                        <p><?php echo e(__('user.filter')); ?></p>
                        <span class="wsus__filter_icon">
                            <i class="far fa-minus" id="minus"></i>
                            <i class="far fa-plus" id="plus"></i>
                        </span>
                    </div>
                    <form id="searchProductFormId">
                    <div class="wsus__product_sidebar" id="sticky_sidebar">
                        <div class="accordion" id="accordionExample">
                            <div class="accordion-item">
                              <h2 class="accordion-header" id="headingOne">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    <?php echo e(__('user.Filter By Categories')); ?>

                                </button>
                              </h2>
                              <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <ul>
                                        <li><a class="categoryForSearch" href="javascript:;" data-category="0"><?php echo e(__('user.All Categories')); ?></a></li>
                                        <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a class="categoryForSearch" href="javascript:;" data-category="<?php echo e($productCategory->slug); ?>"><?php echo e($productCategory->name); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <input type="hidden" name="category" value="" id="category_id_for_search">
                                        <input type="hidden" name="page_view" value="grid_view" id="page_view_id">
                                        <input type="hidden" name="shop_name" value="" id="shop_name">
                                    </ul>
                                </div>
                              </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree3">
                                  <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree3" aria-expanded="false" aria-controls="collapseThree">
                                      <?php echo e(__('user.Filter by Brands')); ?>

                                  </button>
                                </h2>
                                <div id="collapseThree3" class="accordion-collapse collapse show" aria-labelledby="headingThree3" data-bs-parent="#accordionExample">
                                  <div class="accordion-body">
                                      <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check">
                                            <input name="brands[]" class="form-check-input brand_item" type="checkbox" value="<?php echo e($brand->id); ?>" id="flexCheckDefault11-<?php echo e($brand->id); ?>">
                                            <label class="form-check-label" for="flexCheckDefault11-<?php echo e($brand->id); ?>">
                                            <?php echo e($brand->name); ?>

                                            </label>
                                        </div>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  </div>
                                </div>
                              </div>

                            <div class="accordion-item">
                              <h2 class="accordion-header" id="headingTwo">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    <?php echo e(__('user.Filter by Price')); ?>

                                </button>
                              </h2>
                              <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="price_ranger">
                                        <input value="0;<?php echo e($shop_page->filter_price_range); ?>" type="hidden" name="price_range" id="slider_range" class="flat-slider" />
                                        <button  type="submit" class="common_btn"><?php echo e(__('user.filter')); ?></button>
                                    </div>
                                </div>
                              </div>
                            </div>
                            <?php $__currentLoopData = $variantsForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variantForSearch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree2-<?php echo e($variantForSearch->id); ?>">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree2-<?php echo e($variantForSearch->id); ?>" aria-expanded="false" aria-controls="collapseThree">
                                        <?php echo e($variantForSearch->name); ?>

                                    </button>
                                </h2>

                                <div id="collapseThree2-<?php echo e($variantForSearch->id); ?>" class="accordion-collapse collapse show" aria-labelledby="headingThree2-<?php echo e($variantForSearch->id); ?>" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <?php
                                            $variantItemsForSearch = App\Models\ProductVariantItem::groupBy('name')->select('name','id')->where('product_variant_name', $variantForSearch->name)->get();
                                        ?>

                                        <?php $__currentLoopData = $variantItemsForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variantItemForSearch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-check">
                                                <input class="form-check-input variant_item_search" type="checkbox" name="variantItems[]" value="<?php echo e($variantItemForSearch->name); ?>" id="<?php echo e($variantForSearch->id); ?>-<?php echo e($variantItemForSearch->id); ?>-<?php echo e($variantItemForSearch->name); ?>">
                                                <label class="form-check-label" for="<?php echo e($variantForSearch->id); ?>-<?php echo e($variantItemForSearch->id); ?>-<?php echo e($variantItemForSearch->name); ?>">
                                                <?php echo e($variantItemForSearch->name); ?>

                                                </label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <div class="col-xl-9 col-lg-8">
                    <div class="row">
                        <div class="col-xl-12 d-none d-md-block mt-4 mt-lg-0">
                            <div class="wsus__product_topbar">
                                <div class="wsus__product_topbar_left">
                                    <div class="nav nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                        <button onclick="setPageView('grid_view')" class="nav-link active" id="v-pills-home-tab" data-bs-toggle="pill" data-bs-target="#v-pills-home" type="button" role="tab" aria-controls="v-pills-home" aria-selected="true">
                                            <i class="fas fa-th"></i>
                                        </button>
                                        <button onclick="setPageView('list_view')" class="nav-link" id="v-pills-profile-tab" data-bs-toggle="pill" data-bs-target="#v-pills-profile" type="button" role="tab" aria-controls="v-pills-profile" aria-selected="false">
                                            <i class="fas fa-list-ul"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="wsus__topbar_select">
                                    <select class="select_2 shorting_id" name="shorting_id">
                                        <option value="1"><?php echo e(__('user.default shorting')); ?></option>
                                        <option value="2"><?php echo e(__('user.low to high price')); ?> </option>
                                        <option value="3"><?php echo e(__('user.high to low price')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>

                    </form>

                        <div id="loadeer-hidden-content" class="d-none">
                            <div class="row">
                                <div class="col-12 mt-3">
                                    <div class="preloader">
                                        <img src="<?php echo e(asset('user/images/gif.gif')); ?>" alt="loader" class="img-fluid w-100">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-content load_ajax_response" id="v-pills-tabContent">
                            <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                                <div class="row">
                                    <div class="col-12 mt-3">
                                        <div class="preloader">
                                            <img src="<?php echo e(asset('user/images/gif.gif')); ?>" alt="loader" class="img-fluid w-100">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="v-pills-profile" role="tabpanel" aria-labelledby="v-pills-profile-tab">
                                <div class="row">
                                    <div class="col-12 mt-3">
                                        <div class="preloader">
                                            <img src="<?php echo e(asset('user/images/gif.gif')); ?>" alt="loader" class="img-fluid w-100">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
       VENDORS DETAILA END
    ==============================-->

    <script>
        (function($) {
            "use strict";
            $(document).ready(function () {
                loadProductUsingAjax();
                $(".categoryForSearch").on("click", function(){
                    let categoryId = $(this).data('category');
                    $("#category_id_for_search").val(categoryId);
                    submitSearchForm()
                })

                $("#searchProductFormId").on("submit", function(e){
                    let loader = $("#loadeer-hidden-content").html();
                    $('.load_ajax_response').html(loader);

                    e.preventDefault();
                    $.ajax({
                        type: 'get',
                        data: $('#searchProductFormId').serialize(),
                        url: "<?php echo e(route('search-product')); ?>",
                        success: function (response) {
                            $('.load_ajax_response').html(response);
                        },
                        error: function(err) {}
                    });
                })

                $(".brand_item").on("click", function(){
                    submitSearchForm();
                })

                $(".variant_item_search").on("click", function(){
                    submitSearchForm();
                })

                $(".shorting_id").on("change", function(){
                    submitSearchForm();
                })
            });
        })(jQuery);

        function loadAjaxProduct(url){
            let loader = $("#loadeer-hidden-content").html();
            $('.load_ajax_response').html(loader);

            let pageView = $("#page_view_id").val();
            var href = new URL(url);
            href.searchParams.set('page_view', pageView);
            query_url = href.toString()
            $.ajax({
                type: 'get',
                url: query_url,
                success: function (response) {
                    $('.load_ajax_response').html(response);
                },
                error: function(err) {}
            });
        }

        function setPageView(view){
            $("#page_view_id").val(view);
        }

        function loadProductUsingAjax(){
            let loader = $("#loadeer-hidden-content").html();
            $('.load_ajax_response').html(loader);

            let currentURL = window.location.href
            let index = currentURL.indexOf("?");
            currentURL = currentURL.substr(index+1)
            let url = "<?php echo e(url('search-product')); ?>" + "?" + currentURL;
            let shop_name = getUrlParams('shop_name');
            $("#shop_name").val(shop_name);

            $.ajax({
                type: 'get',
                url: url,
                success: function (response) {
                    $('.load_ajax_response').html(response);
                },
                error: function(err) {}
            });
        }

        function submitSearchForm(){
            let loader = $("#loadeer-hidden-content").html();
            $('.load_ajax_response').html(loader);

            $.ajax({
                type: 'get',
                data: $('#searchProductFormId').serialize(),
                url: "<?php echo e(route('search-product')); ?>",
                success: function (response) {
                    $('.load_ajax_response').html(response);
                },
                error: function(err) {}
            });
        }

        function getUrlParams(name){
            var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
            return results[1] || 0;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/seller_detail.blade.php ENDPATH**/ ?>