
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Products')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Edit Product')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Edit Product')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Products')); ?></a>
            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.product.update',$product->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Thumbnail Image Preview')); ?></label>
                                    <div>
                                        <img id="preview-img" class="admin-img" src="<?php echo e(asset($product->thumb_image)); ?>" alt="">
                                    </div>

                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Thumnail Image')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control-file"  name="thumb_image" onchange="previewThumnailImage(event)">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Current Banner Image')); ?></label>
                                    <div>
                                        <img id="preview-img" width="200px" src="<?php echo e(asset($product->banner_image)); ?>" alt="">
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Banner Image')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control-file"  name="banner_image">
                                </div>


                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Short Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="short_name" class="form-control"  name="short_name" value="<?php echo e($product->short_name); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="name" class="form-control"  name="name" value="<?php echo e($product->name); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Slug')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="slug" class="form-control"  name="slug" value="<?php echo e($product->slug); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Category')); ?> <span class="text-danger">*</span></label>
                                    <select name="category" class="form-control select2" id="category">
                                        <option value=""><?php echo e(__('admin.Select Category')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->category_id == $category->id ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Sub Category')); ?></label>
                                    <select name="sub_category" class="form-control select2" id="sub_category">
                                        <option value=""><?php echo e(__('admin.Select Sub Category')); ?></option>
                                        <?php if($product->sub_category_id != 0): ?>
                                            <?php $__currentLoopData = $subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->sub_category_id == $subCategory->id ? 'selected' : ''); ?> value="<?php echo e($subCategory->id); ?>"><?php echo e($subCategory->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Child Category')); ?></label>
                                    <select name="child_category" class="form-control select2" id="child_category">
                                        <option value=""><?php echo e(__('admin.Select Child Category')); ?></option>
                                        <?php if($product->child_category_id != 0): ?>
                                            <?php $__currentLoopData = $childCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->child_category_id == $childCategory->id ? 'selected' : ''); ?> value="<?php echo e($childCategory->id); ?>"><?php echo e($childCategory->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Brand')); ?> <span class="text-danger">*</span></label>
                                    <select name="brand" class="form-control select2" id="brand">
                                        <option value=""><?php echo e(__('admin.Select Brand')); ?></option>
                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->brand_id == $brand->id ? 'selected' : ''); ?> value="<?php echo e($brand->id); ?>"><?php echo e($brand->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SKU')); ?> </label>
                                   <input type="text" class="form-control" name="sku" value="<?php echo e($product->sku); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Price')); ?> <span class="text-danger">*</span></label>
                                   <input type="text" class="form-control" name="price" value="<?php echo e($product->price); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Offer Price')); ?> </label>
                                   <input type="text" class="form-control" name="offer_price" value="<?php echo e($product->offer_price); ?>">
                                </div>



                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Stock Quantity')); ?> <span class="text-danger">*</span></label>
                                   <input type="number" class="form-control" name="quantity" value="<?php echo e($product->qty); ?>">
                                </div>

                                <?php if($product->video_link): ?>
                                    <div class="form-group col-12">
                                        <label><?php echo e(__('admin.Video Preview')); ?></label>
                                        <?php
                                            $video_id=explode("=",$product->video_link);
                                        ?>
                                        <div>
                                            <iframe width="300" height="200"
                                                src="https://www.youtube.com/embed/<?php echo e($video_id[1]); ?>">
                                            </iframe>
                                        </div>

                                    </div>
                                <?php endif; ?>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Video Link')); ?></label>
                                   <input type="text" class="form-control" name="video_link" value="<?php echo e($product->video_link); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Short Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="short_description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($product->short_description); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Long Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="long_description" id="" cols="30" rows="10" class="summernote"><?php echo e($product->long_description); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Tags')); ?></label>
                                   <input type="text" class="form-control tags" name="tags" value="<?php echo e($tags); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Tax')); ?> <span class="text-danger">*</span></label>
                                    <select name="tax" class="form-control">
                                        <option value=""><?php echo e(__('admin.Select Tax')); ?></option>
                                        <?php $__currentLoopData = $productTaxs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->tax_id == $tax->id ? 'selected' : ''); ?>  value="<?php echo e($tax->id); ?>"><?php echo e($tax->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Product Return Availabe ?')); ?> <span class="text-danger">*</span></label>
                                    <select name="is_return" class="form-control" id="is_return" >
                                        <option <?php echo e($product->is_return == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.No')); ?></option>
                                        <option <?php echo e($product->is_return == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Yes')); ?></option>
                                    </select>
                                </div>


                                <?php if($product->is_return == 1): ?>
                                    <div class="form-group col-12" id="policy_box">
                                        <label><?php echo e(__('admin.Return Policy')); ?> <span class="text-danger">*</span></label>
                                        <select name="return_policy_id" class="form-control">
                                            <?php $__currentLoopData = $retrunPolicies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $retrunPolicy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e($product->return_policy_id == $retrunPolicy->id ? 'selected' : ''); ?> value="<?php echo e($retrunPolicy->id); ?>"><?php echo e($retrunPolicy->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php endif; ?>

                                <?php if($product->is_return != 1): ?>
                                    <div class="form-group col-12 d-none" id="policy_box">
                                        <label><?php echo e(__('admin.Return Policy')); ?> <span class="text-danger">*</span></label>
                                        <select name="return_policy_id" class="form-control">
                                            <?php $__currentLoopData = $retrunPolicies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $retrunPolicy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($retrunPolicy->id); ?>"><?php echo e($retrunPolicy->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Warranty Available ?')); ?>  <span class="text-danger">*</span></label>
                                    <select name="is_warranty" class="form-control">
                                        <option <?php echo e($product->is_warranty == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Yes')); ?></option>
                                        <option <?php echo e($product->is_warranty == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.No')); ?></option>
                                    </select>
                                </div>


                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option <?php echo e($product->status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option <?php echo e($product->status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>


                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Title')); ?></label>
                                   <input type="text" class="form-control" name="seo_title" value="<?php echo e($product->seo_title); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Description')); ?></label>
                                    <textarea name="seo_description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($product->seo_description); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Specifications')); ?></label>
                                    <div>
                                        <?php if($product->is_specification==1): ?>
                                            <a href="javascript::void()" id="manageSpecificationBox">
                                                <input name="is_specification" id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="Enable" data-off="Disabled" data-onstyle="success" data-offstyle="danger">
                                            </a>
                                        <?php else: ?>
                                        <a href="javascript::void()" id="manageSpecificationBox">
                                                <input name="is_specification" id="status_toggle" type="checkbox" data-toggle="toggle" data-on="Enable" data-off="Disabled" data-onstyle="success" data-offstyle="danger">
                                            </a>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <?php if($product->is_specification==1): ?>
                                    <div class="form-group col-12" id="specification-box">
                                        <?php if($productSpecifications->count() != 0): ?>
                                            <?php $__currentLoopData = $productSpecifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productSpecification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row mt-2" id="existSpecificationBox-<?php echo e($productSpecification->id); ?>">
                                                    <div class="col-md-5">
                                                        <label><?php echo e(__('admin.Key')); ?> <span class="text-danger">*</span></label>
                                                        <select name="keys[]" class="form-control">
                                                            <?php $__currentLoopData = $specificationKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specificationKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php echo e($specificationKey->id == $productSpecification->product_specification_key_id ? 'selected' : ''); ?> value="<?php echo e($specificationKey->id); ?>"><?php echo e($specificationKey->key); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-5">
                                                        <label><?php echo e(__('admin.Specification')); ?> <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" name="specifications[]" value="<?php echo e($productSpecification->specification); ?>">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <button type="button" class="btn btn-danger plus_btn removeExistSpecificationRow"  data-specificationiId="<?php echo e($productSpecification->id); ?>"><i class="fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <div class="row mt-2">
                                            <div class="col-md-5">
                                                <label><?php echo e(__('admin.Key')); ?> <span class="text-danger">*</span></label>
                                                <select name="keys[]" class="form-control">
                                                    <?php $__currentLoopData = $specificationKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specificationKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($specificationKey->id); ?>"><?php echo e($specificationKey->key); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-5">
                                                <label><?php echo e(__('admin.Specification')); ?> <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" name="specifications[]">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-success plus_btn" id="addNewSpecificationRow"><i class="fas fa-plus"></i></button>
                                            </div>
                                        </div>

                                    </div>
                                <?php endif; ?>

                                <?php if($product->is_specification==0): ?>
                                    <div class="form-group col-12 d-none" id="specification-box">
                                        <?php if($productSpecifications->count() != 0): ?>
                                            <?php $__currentLoopData = $productSpecifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productSpecification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row mt-2" id="existSpecificationBox-<?php echo e($productSpecification->id); ?>">
                                                    <div class="col-md-5">
                                                        <label><?php echo e(__('admin.Key')); ?> <span class="text-danger">*</span></label>
                                                        <select name="keys[]" class="form-control">
                                                            <?php $__currentLoopData = $specificationKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specificationKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php echo e($specificationKey->id == $productSpecification->product_specification_key_id ? 'selected' : ''); ?> value="<?php echo e($specificationKey->id); ?>"><?php echo e($specificationKey->key); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-5">
                                                        <label><?php echo e(__('admin.Specification')); ?> <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" name="specifications[]" value="<?php echo e($productSpecification->specification); ?>">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <button type="button" class="btn btn-danger plus_btn removeExistSpecificationRow"  data-specificationiId="<?php echo e($productSpecification->id); ?>"><i class="fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <div class="row mt-2">
                                            <div class="col-md-5">
                                                <label><?php echo e(__('admin.Key')); ?> <span class="text-danger">*</span></label>
                                                <select name="keys[]" class="form-control">
                                                    <?php $__currentLoopData = $specificationKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specificationKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($specificationKey->id); ?>"><?php echo e($specificationKey->key); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-5">
                                                <label><?php echo e(__('admin.Specification')); ?> <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" name="specifications[]">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-success plus_btn" id="addNewSpecificationRow"><i class="fas fa-plus"></i></button>
                                            </div>
                                        </div>

                                    </div>
                                <?php endif; ?>




                                <div id="hidden-specification-box" class="d-none">
                                    <div class="delete-specification-row">
                                        <div class="row mt-2">
                                            <div class="col-md-5">
                                                <label><?php echo e(__('admin.Key')); ?> <span class="text-danger">*</span></label>
                                                <select name="keys[]" class="form-control">
                                                    <?php $__currentLoopData = $specificationKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specificationKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($specificationKey->id); ?>"><?php echo e($specificationKey->key); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-5">
                                                <label><?php echo e(__('admin.Specification')); ?> <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" name="specifications[]">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-danger plus_btn deleteSpeceficationBtn"><i class="fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>


<script>
    (function($) {
        "use strict";
        var specification = '<?php echo e($product->is_specification == 1 ? true : false); ?>';
        $(document).ready(function () {
            $("#name").on("focusout",function(e){
                $("#slug").val(convertToSlug($(this).val()));
            })

            $("#category").on("change",function(){
                var categoryId = $("#category").val();
                if(categoryId){
                    $.ajax({
                        type:"get",
                        url:"<?php echo e(url('/admin/subcategory-by-category/')); ?>"+"/"+categoryId,
                        success:function(response){
                            $("#sub_category").html(response.subCategories);
                            var response= "<option value=''><?php echo e(__('admin.Select Child Category')); ?></option>";
                            $("#child_category").html(response);

                        },
                        error:function(err){
                            console.log(err);

                        }
                    })
                }else{
                    var response= "<option value=''><?php echo e(__('admin.Select Sub Category')); ?></option>";
                    $("#sub_category").html(response);
                    var response= "<option value=''><?php echo e(__('admin.Select Child Category')); ?></option>";
                    $("#child_category").html(response);
                }


            })

            $("#sub_category").on("change",function(){
                var SubCategoryId = $("#sub_category").val();
                if(SubCategoryId){
                    $.ajax({
                        type:"get",
                        url:"<?php echo e(url('/admin/childcategory-by-subcategory/')); ?>"+"/"+SubCategoryId,
                        success:function(response){
                            $("#child_category").html(response.childCategories);
                        },
                        error:function(err){
                            console.log(err);

                        }
                    })
                }else{
                    var response= "<option value=''><?php echo e(__('admin.Select Child Category')); ?></option>";
                    $("#child_category").html(response);
                }

            })

            $("#is_return").on('change',function(){
                var returnId = $("#is_return").val();
                if(returnId == 1){
                    $("#policy_box").removeClass('d-none');
                }else{
                    $("#policy_box").addClass('d-none');
                }

            })

            $("#addNewSpecificationRow").on('click',function(){
                var html = $("#hidden-specification-box").html();
                $("#specification-box").append(html);
            })

            $(document).on('click', '.deleteSpeceficationBtn', function () {
                $(this).closest('.delete-specification-row').remove();
            });


            $("#manageSpecificationBox").on("click",function(){
                if(specification){
                    specification = false;
                    $("#specification-box").addClass('d-none');
                }else{
                    specification = true;
                    $("#specification-box").removeClass('d-none');
                }


            })

            $(".removeExistSpecificationRow").on("click",function(){
                var isDemo = "<?php echo e(env('APP_VERSION')); ?>"
                if(isDemo == 0){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                var specificationId = $(this).attr("data-specificationiId");
                $.ajax({
                    type:"put",
                    data: { _token : '<?php echo e(csrf_token()); ?>' },
                    url:"<?php echo e(url('/admin/removed-product-exist-specification/')); ?>"+"/"+specificationId,
                    success:function(response){
                        toastr.success(response)
                        $("#existSpecificationBox-"+specificationId).remove();
                    },
                    error:function(err){
                        console.log(err);

                    }
                })
            })

        });
    })(jQuery);

    function convertToSlug(Text){
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g,'')
                .replace(/ +/g,'-');
    }

    function previewThumnailImage(event) {
        var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('preview-img');
            output.src = reader.result;
        }
        reader.readAsDataURL(event.target.files[0]);
    };

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/edit_product.blade.php ENDPATH**/ ?>