
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Product Brand')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Edit Product Brand')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.product-brand.index')); ?>"><?php echo e(__('admin.Product Brand')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Edit Product Brand')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product-brand.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Product Brand')); ?></a>
            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.product-brand.update',$brand->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Existing Logo')); ?></label>
                                    <div>
                                        <img src="<?php echo e(asset($brand->logo)); ?>" width="100px" alt="">
                                    </div>
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Logo')); ?></label>
                                    <input type="file" class="form-control-file"  name="logo">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="name" class="form-control"  name="name" value="<?php echo e($brand->name); ?>">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Slug')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="slug" class="form-control"  name="slug" value="<?php echo e($brand->slug); ?>">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Rating')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="rating" class="form-control"  name="rating" value="<?php echo e($brand->rating); ?>">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option <?php echo e($brand->status==1 ? 'selected': ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option <?php echo e($brand->status==0 ? 'selected': ''); ?>  value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $("#name").on("focusout",function(e){
                $("#slug").val(convertToSlug($(this).val()));
            })
        });
    })(jQuery);

    function convertToSlug(Text)
        {
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g,'')
                .replace(/ +/g,'-');
        }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/admin/edit_product_brand.blade.php ENDPATH**/ ?>