
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seoSetting->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seoSetting->seo_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('public-content'); ?>


    <!--============================
         BREADCRUMB START
    ==============================-->
    <section id="wsus__breadcrumb" style="background: url(<?php echo e(asset($banner->image)); ?>);">
        <div class="wsus_breadcrumb_overlay">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(__('user.Seller')); ?></h4>
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="<?php echo e(route('sellers')); ?>"><?php echo e(__('user.Seller')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============================
        BREADCRUMB END
    ==============================-->



    <!--============================
      VENDORS DETAILA START
    ==============================-->
    <section id="wsus__product_page" class="wsus__vendors">
        <div class="container">
            <div class="row">
                <?php if($sellers->count() > 0): ?>
                <div class="col-12">
                    <div class="row">
                        <?php $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-6 col-md-6">
                            <div class="wsus__vendor_single">
                                <img src="<?php echo e(asset($seller->banner_image)); ?>" alt="vendor" class="img-fluid w-100">
                                <div class="wsus__vendor_text">
                                    <div class="wsus__vendor_text_center">
                                        <h4><?php echo e($seller->shop_name); ?></h4>

                                        <?php
                                            $reviewQty = App\Models\ProductReview::where('status',1)->where('product_vendor_id',$seller->id)->count();
                                            $totalReview = App\Models\ProductReview::where('status',1)->where('product_vendor_id',$seller->id)->sum('rating');
                                            if ($reviewQty > 0) {
                                                $average = $totalReview / $reviewQty;
                                                $intAverage = intval($average);
                                                $nextValue = $intAverage + 1;
                                                $reviewPoint = $intAverage;
                                                $halfReview=false;
                                                if($intAverage < $average && $average < $nextValue){
                                                    $reviewPoint= $intAverage + 0.5;
                                                    $halfReview=true;
                                                }
                                            }
                                        ?>

                                        <?php if($reviewQty > 0): ?>
                                        <p class="wsus__vendor_rating">
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $reviewPoint): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $reviewPoint ): ?>
                                                    <?php if($halfReview==true): ?>
                                                    <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $halfReview=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="fal fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span>(<?php echo e($reviewQty); ?> <?php echo e(__('user.review')); ?>)</span>
                                        </p>
                                        <?php endif; ?>

                                        <?php if($reviewQty == 0): ?>
                                            <p class="wsus__vendor_rating">
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <i class="fal fa-star"></i>
                                                <span>(0 <?php echo e(__('user.review')); ?>)</span>
                                            </p>
                                        <?php endif; ?>

                                        <a href="callto:<?php echo e($seller->phone); ?>"><i class="far fa-phone-alt"></i> <?php echo e($seller->phone); ?></a>
                                        <a href="mailto:<?php echo e($seller->email); ?>"><i class="fal fa-envelope"></i> <?php echo e($seller->email); ?></a>
                                        <a href="<?php echo e(route('seller-detail',['shop_name' => $seller->slug])); ?>" class="common_btn"><?php echo e(__('user.visit store')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php else: ?>
                <div class="col-12 text-center">
                    <h3 class="text-danger"><?php echo e(__('user.Seller not found')); ?></h3>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/luckyledger/public_html/resources/views/seller.blade.php ENDPATH**/ ?>