<?php

namespace App\Http\Controllers\Api\Report;

use App\Http\Controllers\Controller;
use App\Models\FoodItem;
use App\Models\OnlineOrderItem;
use App\Models\OrderGroup;
use App\Models\OrderItem;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\DepartmentTag;
use App\Models\OnlineOrderGroup;
use App\Models\Temporary;

class XandYController extends Controller
{
    // get report info
    public function getReportInfo($workPeriod_start)
    {
        // get requested date from workperiod
        $req_date = Carbon::parse($workPeriod_start)->format('Y-m-d');
        $req_date_start =  $req_date . ' 00:00:00';
        $req_date_end =  $req_date . ' 23:59:59';

        // get all pos order
        $today_all_pos_order = OrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->get();

        // get all online order
        $today_all_online_order = OnlineOrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->get();

        // merge online and pos order
        $all_order = array_merge($today_all_pos_order->toArray(), $today_all_online_order->toArray());


        /*******  ITEMS & ITEMS CATEGORIES START   ********/

        $categories_list_price = [];
        $categories_total_price = [];
        $category_list = [];
        $category_items_length = [];
        $items_quantities = [];
        $items_prices = [];


        // spliting to new array with food group
        foreach ($all_order as $single_order) {
            $categories_list_price[$single_order['food_group']][] = $single_order['price'];
            $items_quantities[] = $single_order['quantity'];
            $items_prices[] = $single_order['price'];
            $category_list[] = $single_order['food_group'];
        }

        // remove duplicate categories
        $category_list = array_unique($category_list);

        // getting the total value of categories price
        foreach ($categories_list_price as $price) {
            $categories_total_price[] = array_sum($price);
            $category_items_length[] = count($price);
        }

        /*******  ITEMS & ITEMS CATEGORIES END   ********/


        /*******  DEPARTMENT  START   ********/

        // online (all online orders are delivery tags)
        $total_dep_online_price =  $today_all_online_order->sum('price');
        $items_dep_online_length = count($today_all_online_order);

        // pos
        $dep_pos_collection = [];
        $dep_pos_tags =  DepartmentTag::get()->pluck('name');

        foreach ($dep_pos_tags as $single_pos_tags) {
            $dep_pos_collection[] =  OrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->where('department_tags', $single_pos_tags)->get();
        }
        $items_dep_pos_total_price = [];
        $items_pos_length = [];

        // return  $dep_pos_collection;

        // get total price of pos department wise sales
        foreach ($dep_pos_collection as $tags) {
            $items_dep_pos_total_price[] = $tags->sum('price');
            // get product length
            $items_pos_length[] = count($tags);
        }

        // remove last(delivery) price 
        $get_pos_delivery_price =  array_pop($items_dep_pos_total_price);

        // sum of online and pos delivery price
        $get_pos_delivery_price = $get_pos_delivery_price +  $total_dep_online_price;
        // push total delivery value to dept array
        array_push($items_dep_pos_total_price, $get_pos_delivery_price);

        // remove last(delivery) length
        $get_pos_delivery_length =  array_pop($items_pos_length);

        // sum of online and pos delivery length
        $get_pos_delivery_length = $get_pos_delivery_length +  $items_dep_online_length;
        // push total delivery value to dept array
        array_push($items_pos_length, $get_pos_delivery_length);


        /*******  DEPARTMENT  END   ********/

        /*******  PAYMENT  START   ********/
        $online_cod_orders = OnlineOrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->where('payment_method', 'COD')->get();

        $online_card_orders = OnlineOrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->where('payment_method', '!=', 'COD')->get();

        // cod total price
        $online_cod_total_price =  $online_cod_orders->sum('price');
        $pos_cod_price = $today_all_pos_order->sum('price');
        $cod_total_price = $online_cod_total_price + $pos_cod_price;

        //total cod count
        $online_cod_count = count($online_cod_orders);
        $online_pos_count = count($today_all_pos_order);
        $total_cod_count =  $online_cod_count + $online_pos_count;

        // card total price
        $online_card_total_price =  $online_card_orders->sum('price');

        // total card count 
        $total_card_count = count($online_card_orders);

        /*******  PAYMENT  END   ********/



        return  [
            //item categories
            'categories' => $category_list,
            'categories_list_price' =>  $categories_total_price,
            'categories_list_length' => $category_items_length,
            'categories_total_price' => array_sum($categories_total_price),
            'categories_total_length' => array_sum($category_items_length),
            // items
            'items' => $all_order,
            'total_items_quantity' => array_sum($items_quantities),
            'total_items_price' => array_sum($items_prices),
            // deps
            'dep_tags' =>  $dep_pos_tags,
            'dept_items_length' =>   $items_pos_length,
            'dept_items_total_length' =>   array_sum($items_pos_length),
            'dept_items_price' => $items_dep_pos_total_price,
            'total_dep_price' =>  array_sum($items_dep_pos_total_price),
            // payment
            'cash_total' =>  $cod_total_price,
            'total_cash_count' =>  $total_cod_count,
            'card_total' =>  $online_card_total_price,
            'total_card_count' =>  $total_card_count,
            'total_payment_count' => $total_cod_count + $total_card_count,
            'total_payment' =>  $cod_total_price + $online_card_total_price
        ];
    }

    // generate today items list 
    public function generateXReport($workPeriod_start)
    {
        // get the updated date from workperiod
        $req_date = Carbon::parse($workPeriod_start)->format('Y-m-d');

        $req_date_start =  $req_date . ' 00:00:00';
        $req_date_end =  $req_date . ' 23:59:59';

        $today_start = Carbon::now()->format('Y-m-d 00:00:00');
        $today_end = Carbon::now()->format('Y-m-d 23:59:59');

        // return [
        //     'custome data' => $today_start,
        //     'build in date' => $req_date_start
        // ];

        // $today_all_order = OrderItem::whereBetween('created_at', [$today_start, $today_end])->get();
        $today_all_order = OrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->get();

        $total_items_pos_sale = count($today_all_order);
        $total_items_pos_price =   $today_all_order->sum('price');

        // get all todays order id
        $today_all_order_id = [];
        foreach ($today_all_order as $order) {
            $today_all_order_id[] = $order->food_item_id;
        }

        // make unique todays order id 
        $unique_value = array_unique($today_all_order_id);

        // store each orders as collection of id
        $product_collections = [];
        foreach ($unique_value as $single_id) {
            $product_collections[] = OrderItem::whereBetween('created_at', [$today_start, $today_end])->where('food_item_id', $single_id)->get();
        }

        $product_length = [];
        $product_names = [];
        $product_total_price = [];

        foreach ($product_collections as $products) {
            // get product length
            $product_length[] = count($products);
            // sum of related product
            $product_total_price[] = $products->sum('price');

            foreach ($products as $single_product) {
                // get the name
                $product_names[] = $single_product->food_item;
            }
        }

        // get total price and total items
        $product_group_total_price = array_sum($product_total_price);
        $product_group_total_items = array_sum($product_length);

        return response()
            ->json(
                [
                    'product_list' => $today_all_order,
                    'product_name' => array_unique($product_names),
                    'prouduct_length' => $product_length,
                    'product_price' =>  $product_total_price,
                    'product_total_group_price' =>  $product_group_total_price,
                    'product_total_group_items' =>  $product_group_total_items,
                    'total_items_pos_sale' => $total_items_pos_sale,
                    'total_items_pos_price' =>     $total_items_pos_price
                ]
            );
    }

    // generate today online items list
    public function generateXReportOnline()
    {
        // get todays order
        $today_start = Carbon::now()->format('Y-m-d 00:00:00');
        $today_end = Carbon::now()->format('Y-m-d 23:59:59');
        $today_all_order = OnlineOrderItem::whereBetween('created_at', [$today_start, $today_end])->get();
        // $today_all_order = $this->getTodayOrder();
        // get all todays order id
        $today_all_order_id = [];
        foreach ($today_all_order as $order) {
            $today_all_order_id[] = $order->food_item_id;
        }

        // return $today_all_order_id;

        // make unique todays order id 
        $unique_value = array_unique($today_all_order_id);

        // store each orders as collection of id
        $product_collections = [];
        foreach ($unique_value as $single_id) {
            $product_collections[] = OrderItem::whereBetween('created_at', [$today_start, $today_end])->where('food_item_id', $single_id)->get();
        }

        $product_length = [];
        $product_names = [];
        $product_total_price = [];

        foreach ($product_collections as $products) {
            // get product length
            $product_length[] = count($products);
            // sum of related product
            $product_total_price[] = $products->sum('price');

            foreach ($products as $single_product) {
                // get the name
                $product_names[] = $single_product->food_item;
            }
        }

        // get total price and total items
        $product_group_total_price = array_sum($product_total_price);
        $product_group_total_items = array_sum($product_length);

        return response()
            ->json(
                [
                    // 'product_list' =>  $product_collections,
                    'product_name' => array_unique($product_names),
                    'prouduct_length' => $product_length,
                    'product_price' =>  $product_total_price,
                    'product_total_group_price' =>    $product_group_total_price,
                    'product_total_group_items' =>        $product_group_total_items,
                ]
            );
    }

    // get department tag wise order for pos
    public function getDepartmentPosOrder($workPeriod_start)
    {
        // get the updated date from workperiod
        $req_date = Carbon::parse($workPeriod_start)->format('Y-m-d');

        $req_date_start =  $req_date . ' 00:00:00';
        $req_date_end =  $req_date . ' 23:59:59';
        // $today_start = Carbon::now()->format('Y-m-d 00:00:00');
        // $today_end = Carbon::now()->format('Y-m-d 23:59:59');
        $dep_tags =  DepartmentTag::get()->pluck('name');
        $dep_collection = [];

        // store each dept tag orders array
        foreach ($dep_tags as $single_tags) {
            $dep_collection[] =  OrderItem::whereBetween('created_at', [$req_date_start, $req_date_end])->where('department_tags', $single_tags)->get();
        }

        $product_total_price = [];
        $product_length = [];

        // sum of related product
        foreach ($dep_collection as $tags) {
            $product_total_price[] = $tags->sum('price');
            // get product length
            $product_length[] = count($tags);
        }

        // total dept price
        $total_price = array_sum($product_total_price);

        return  [
            'dep_tags' => $dep_tags,
            'dept_product_length' =>   $product_length,
            'dept_price' => $product_total_price,
            'total_price' =>   $total_price
        ];
    }

    // public function todayPosOrder()
    // {
    //     $today_start = Carbon::now()->format('Y-m-d 00:00:00');
    //     $today_end = Carbon::now()->format('Y-m-d 23:59:59');
    //     $today_pos_order =  OrderItem::whereBetween('created_at', [$today_start, $today_end])->get();
    //     $total_items_sale = count($today_pos_order);
    //     $total_items_price = $today_pos_order->sum('price');
    //     return [
    //         'today_pos_order' => $today_pos_order,
    //         'total_items_sale' => $total_items_sale,
    //         'total_items_price' => $total_items_price,
    //     ];
    // }
}
