<?php

namespace App\Http\Controllers\Api\Reservation;

use App\Http\Controllers\Controller;
use App\Models\ReservationInfo;
use Illuminate\Http\Request;
use App\Models\ReservationSection;
use App\Models\Table;

class ReservationSectionController extends Controller
{

    public function index()
    {
        return ReservationSection::with('waiters')->get();
    }

    // save section name
    public function saveSection(Request $request)
    {
        $rsv_section = new ReservationSection;
        $rsv_section->name = $request->name;
        // optional
        if ($request->table_group_id) {
            $rsv_section->table_group_id = $request->table_group_id;
        }
        if ($request->waiter_id) {
            $rsv_section->waiter_id = $request->waiter_id;
        }
        $rsv_section->save();

        return response()->json([
            'status' => 200,
            'message' => 'Successfully added',
            'data' => $this->index()
        ]);
    }
    // edit section name
    public function editSection(Request $request, $id)
    {
        $rsv_section = ReservationSection::where('id', $id)->first();
        $rsv_section->name = $request->name;
        // optional
        if ($request->table_group_id) {
            $rsv_section->table_group_id = $request->table_group_id;
        }
        if ($request->waiter_id) {
            $rsv_section->waiter_id = $request->waiter_id;
        }
        $rsv_section->save();

        return response()->json([
            'status' => 200,
            'message' => 'Successfully added',
        ]);
    }

    // delete section name
    public function deleteSection(Request $request, $id)
    {
        $rsv_section = ReservationSection::where('id', $id)->first();

        if ($rsv_section->table_group_id === null) {
            $rsv_section->delete();
            return response()->json([
                'status' => 200,
                'message' => 'Section deleted successfully',
                'data' => $this->index()
            ]);
        } else {
            $all_table_id = json_decode($rsv_section->table_group_id, true);
            foreach ($all_table_id as $id) {
                $table = Table::where('id', $id)->first();
                $table->assigned_to_section = "no";
                $table->save();
            }
            $rsv_section->delete();
            return response()->json([
                'status' => 200,
                'message' => 'Section deleted successfully',
                'data' => $this->index()
            ]);
        }
    }

    // assign tables to section
    public function assignTable(Request $request, $id)
    {
        // return $request;

        $rsv_section = ReservationSection::where('id', $id)->first();
        $new_table = $request->table_group_id;
        $old_tables = json_decode($rsv_section->table_group_id);

        if ($old_tables !== null) {
            foreach ($old_tables as $old_id) {
                $old_table = Table::where('id', $old_id)->first();
                $old_table->assigned_to_section = "no";
                $old_table->save();
            }
        }
        foreach ($new_table as $id) {
            $table = Table::where('id', $id)->first();
            $table->assigned_to_section = "yes";
            $table->save();
        }

        $rsv_section->table_group_id = $new_table;
        $rsv_section->save();
        return response()->json([
            'status' => 200,
            'message' => 'Table added Successfully',
        ]);
    }

    // get section assigned table 
    public function sectionAssignedTable(Request $req, $id)
    {
        $rsv_section_tables = ReservationSection::where('id', $id)->select('table_group_id')->first();
        $tables_id =  json_decode($rsv_section_tables->table_group_id);

        $tables = [];
        foreach ($tables_id as $id) {
            $tables[] = Table::where('id', $id)->first();
        }
        return $tables;
    }

    // assign waiter to section
    public function assignWaiter(Request $request)
    {
        // section table 
        $rsv_section = ReservationSection::where('id', $request->section_id)->first();
        $rsv_section->waiter_id = $request->waiter_id;
        $rsv_section->save();

        // code here 
        $rsv_assign_tables = json_decode($rsv_section->table_group_id);

        foreach ($rsv_assign_tables as $id) {
            $table = Table::where('id', $id)->first();
            $table->waiter_id = $request->waiter_id;
            $table->save();
        }
        // end here



        return $this->index();
        // return response()->json([
        //     'status' => 200,
        //     'message' => 'Waiter added Successfully',
        // ]);
    }
}