<?php

namespace App\Http\Controllers\Api\RestaurantDetails;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\Temporary;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Image;
class BranchController extends Controller
{
    //get all branch web
    public function indexWeb()
    {
        $branches = Branch::all()->toArray();
        return $branches;
    }

    //get all branch
    public function index()
    {
        $branches = Branch::all()->toArray();
        return [customPaginate($branches), $branches];
    }

    //save new branch
    public function store(Request $request)
    {
        // testing end
        $branch = new Branch;
        $branch->name = $request->name;
        $branch->delivery_fee = $request->delivery_fee;
        $branch->phn_no = $request->phn_no;
        $branch->address = $request->address;
        $branch->slug =  Str::random(3).'-'.time().'-'.Str::slug($request->name);

        if($request->active) {
            switch ($request->active) {
                case 'true':
                    $branch->active = 1;
                    break;
                case 'false':
                    $branch->active = 0;
                    break;
                default:
                    $branch->active = 0;
                    break;
            }
        }


        if($request->hasFile('banner')) {
            $request->validate(
                [
                  'banner' => 'image|mimes: jpeg,png,jpg|max:10000'
                ]
              );

              $photo_upload     =  $request ->banner;
              $photo_extension  =  $photo_upload -> getClientOriginalExtension();
              $photo_name       =  time() . "." . $photo_extension;
              $path             =  base_path('public/uploads/'.$photo_name);
              Image::make($photo_upload)->save($path);

              $branch->saas_banner =  $photo_name ;
        }
        if($request->hasFile('thumb')) {
            $request->validate(
                [
                  'thumb' => 'image|mimes: jpeg,png,jpg|max:10000'
                ]
              );

              $photo_upload     =  $request ->thumb;
              $photo_extension  =  $photo_upload -> getClientOriginalExtension();
              $photo_name       =  time() . "." . $photo_extension;
              $path             =  base_path('public/uploads/'.$photo_name);
              Image::make($photo_upload)->save($path);

              $branch->saas_thumb =  $photo_name ;
        }
        $branch->save();

        //get all branch
        return $this->index();
    }

    //update branch
    public function update(Request $request)
    {
        // return $request;
        $branch = Branch::where('slug', $request->editSlug)->first();
        $branch->name = $request->name;
        $branch->delivery_fee = $request->delivery_fee;
        $branch->phn_no = $request->phn_no;
        $branch->address = $request->address;
        $branch->slug =  Str::random(3).'-'.time().'-'.Str::slug($request->name);
        if($request->active) {
            switch ($request->active) {
                case 'true':
                    $branch->active = 1;
                    break;
                case 'false':
                    $branch->active = 0;
                    break;
                default:
                    $branch->active = 0;
                    break;
            }
        }


        if($request->hasFile('banner')) {
            $request->validate(
                [
                  'banner' => 'image|mimes: jpeg,png,jpg|max:10000'
                ]
              );

              $photo_upload     =  $request ->banner;
              $photo_extension  =  $photo_upload -> getClientOriginalExtension();
              $photo_name       =  time() . "." . $photo_extension;
              $path             =  base_path('public/uploads/'.$photo_name);
              Image::make($photo_upload)->save($path);

              $branch->saas_banner =  $photo_name ;
        }
        if($request->hasFile('thumb')) {
            $request->validate(
                [
                  'thumb' => 'image|mimes: jpeg,png,jpg|max:10000'
                ]
              );

              $photo_upload     =  $request ->thumb;
              $photo_extension  =  $photo_upload -> getClientOriginalExtension();
              $photo_name       =  time() . "." . $photo_extension;
              $path             =  base_path('public/uploads/'.$photo_name);
              Image::make($photo_upload)->save($path);

              $branch->saas_thumb =  $photo_name ;
        }
        $branch->save();

        //get all branch
        return $this->index();
    }

    //delete branch
    public function destroy($slug)
    {
        $branch = Branch::where('slug', $slug)->first();
        $user = User::where('branch_id', $branch->id)->where('is_banned', 0)->first();
        if (is_null($user)) {
            $branch->delete();
            //get all branch
            return $this->index();
        } else {
            return "user";
        }
    }
}