<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BankTransferOrderMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    public $clients_name;

    public function __construct($clients_name)
    {
        $this->clients_name = $clients_name;
    }

    public function build()
    {
        return $this->subject('Order Successfull')
            ->view('email.order_bank_transfer')
            ->with([
                'user_name' => $this->clients_name,
            ]);

    }
}
