<?php

namespace App\Console\Commands;

use App\Jobs\ResetDB;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class DBResetCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'db:reset';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (env('DEMO',  "NO") == 'YES') {
            $drop_path = base_path('drop_tables.sql');
            DB::unprepared(file_get_contents($drop_path));

            $sql_path = base_path('reset_khadyo.sql');
            DB::unprepared(file_get_contents($sql_path));
        }
        return Command::SUCCESS;
    }
}
