<?php

namespace App\Http\Controllers\Api\payment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Stripe\Charge;
use Stripe\Stripe;
use Stripe\StripeClient;
use Illuminate\Support\Facades\Validator;
use Session;

class StripeController extends Controller
{
  //handle stripe payment
  public function handleStripe(Request $request)
  {

    // get total amount
    $getTotal = (float)$request->delivery_charge + (float)$request->subTotal + (float)$request->vat;

    // get stripe token key
    $stripe = new \Stripe\StripeClient(
      env('STRIPE_SECRET')
    );

    //  create stripe token 
    $stripetoken = $stripe->tokens->create([
      'card' => [
        'number' => $request->stripe_card_number,
        'address_zip' => $request->stripe_zip_code,
        'exp_month' => $request->stripe_card_exp_month,
        'exp_year' => $request->stripe_card_exp_year,
        'cvc' => $request->stripe_card_cvc,
      ],
    ]);

    //  make actual payment
    $stripe->charges->create([
      "amount" => $getTotal * 100,
      "currency" => "usd",
      "source" => $stripetoken,
      'description' => $request->stripe_card_name,
      'statement_descriptor' => env('STATEMENT_DESCRIPTOR'),
    ]);

    // store information for reference destroy after saving information to database
    Session::put("stripetoken", $stripetoken->id);
    return $this->callbackStripe();
  }

  // callback function
  public function callbackStripe()
  {
    $stripe = new \Stripe\StripeClient(
      env('STRIPE_SECRET')
    );
    return $stripe->tokens->retrieve(
      Session::get("stripetoken"),
      []
    );
  }
  // set up stripe
  public function setStripe(Request $req)
  {
    overWriteEnvFile('STRIPE_KEY', $req->clientId);
    overWriteEnvFile('STRIPE_SECRET', $req->secretKey);
    overWriteEnvFile('STATEMENT_DESCRIPTOR', $req->statementDescriptor);

    if ($req->show == "true") {
      overWriteEnvFile('STRIPE_SHOW', "YES");
    } else if ($req->show == "false") {
      overWriteEnvFile('STRIPE_SHOW', "NO");
    }
    // Artisan::call('optimize:clear');
    return 'Okk';
  }

  //  stripe info
  public function showStripeInfo()
  {
    $allInfo = [];
    $allInfo = array(
      "STRIPE_KEY" => env('STRIPE_KEY'),
      "STRIPE_SECRET" => env('STRIPE_SECRET'),
      "STRIPE_SHOW" => env('STRIPE_SHOW'),
      "STATEMENT_DESCRIPTOR" => env('STATEMENT_DESCRIPTOR'),
    );

    return $allInfo;
  }

  // store info and connect card reader
  public function connectCardReader(Request $req)
  {
    // return $req;
    // store info
    overWriteEnvFile('STRIPE_CARD_REG_CODE', $req->card_reg_code);
    overWriteEnvFile('STRIPE_CARD_LABEL', $req->card_label);
    overWriteEnvFile('STRIPE_CARD_LOCATION_ID', $req->card_location_id);
    if ($req->show == "true") {
      overWriteEnvFile('STRIPE_CARD_SHOW', "YES");
    } else if ($req->show == "false") {
      overWriteEnvFile('STRIPE_CARD_SHOW', "NO");
    }

    Stripe::setApiKey(env('STRIPE_SECRET'));

    // //add location and pairing code
    $resultCardReaderCreate =  \Stripe\Terminal\Reader::create([
      'registration_code' => env("STRIPE_CARD_REG_CODE"),
      'label' => env("STRIPE_CARD_LABEL"),
      'location' => env("STRIPE_CARD_LOCATION_ID"),
    ]);

    // return $resultCardReaderCreate->status;
  }

  // list all stripe card reader
  public function listAllCardReader()
  {
    Stripe::setApiKey(env('STRIPE_SECRET'));
    $allReader = \Stripe\Terminal\Reader::all();
    return $allReader->data;
  }

  // make payment with card reader
  public function makeCardPayment(Request $req)
  {

    $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));

    $invoice = rand(100, 1000);

    // create payment intent
    $stripe->paymentIntents->create(
      [
        'currency' => 'usd',
        'payment_method_types' => ['card_present'],
        'capture_method' => 'manual',
        'description' => $invoice,
        'amount' => $req->totalPayable * 100,
      ]
    );

    // filter paymentIntents for payment id
    $allPayment = $stripe->paymentIntents->all();
    $paymentId = null;

    foreach ($allPayment['data'] as $payment) {
      if ($payment->description == $invoice) {
        $paymentId = $payment->id;
      }
    }

    // filter readers for id
    $allReaders = $stripe->terminal->readers->all();
    $singleReaderId = null;

    foreach ($allReaders['data'] as $singleReader) {
      if ($singleReader->registration_code == env('STRIPE_CARD_REG_CODE')) {
        $singleReaderId = $singleReader->id;
      }
    }

    // process the payment to card reader
    $stripe->terminal->readers->processPaymentIntent(
      $singleReaderId,
      ['payment_intent' => $paymentId]
    );

    // retrive data
    $stripe->terminal->readers->retrieve($singleReaderId, []);

    // capture the payment
    $cardPaymentResult = $stripe->paymentIntents->capture($singleReaderId, []);

    //  show result
    return $cardPaymentResult->status;
  }
}