<?php

namespace App\Http\Controllers\Api\template;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TemplateOne;
use App\Models\TemplateOneGallerie;
use Illuminate\Support\Facades\Validator;
use Image;
use Hash;

use function PHPUnit\Framework\isNull;

class TemplateOneController extends Controller
{
    // hero section
    public function hero(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'heroTitle' => 'required',
            'heroTagTitle' => 'required',
            'heroBadgeTitle' => 'required',
            'heroNumber' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {
            $heroImg = TemplateOne::where('name', 'heroImage')->first();
            $heroTitle = TemplateOne::where('name', 'heroTitle')->first();
            $heroTagTitle = TemplateOne::where('name', 'heroTagTitle')->first();
            $heroBadgeTitle = TemplateOne::where('name', 'heroBadgeTitle')->first();
            $heroNumber = TemplateOne::where('name', 'heroNumber')->first();

            //hero image
            $checkNull = $request->file('heroImage');
            if (!is_null($checkNull)) {
                if ($heroImg) {
                    // if req file heroImg
                    if ($request->hasFile('heroImage')) {
                        $request->validate(
                            [
                                'heroImage' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        // get the value from db
                        $delete_photo = $heroImg->value;
                        // delete old photo
                        $checkfile = base_path('public/uploads/' . $delete_photo);
                        if (file_exists($checkfile)) {
                            unlink(base_path('public/uploads/' . $delete_photo));
                        }
                        // update
                        $photo_upload     =  $request->heroImage;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);
                        $heroImg->update([
                            'value' =>  $photo_name,
                        ]);
                    } else {
                        return 'invalid file from existing value';
                    }
                } else {
                    // create new one
                    if ($request->hasFile('heroImage')) {
                        $request->validate(
                            [
                                'heroImage' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $photo_upload     =  $request->heroImage;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);

                        // set new value
                        $newItem = new TemplateOne;
                        $newItem->name = 'heroImage';
                        $newItem->value =  $photo_name;
                        $newItem->save();
                    } else {
                        return 'invalid file from new one';
                    }
                }
            }


            // hero title
            if ($heroTitle) {
                $heroTitle->update([
                    'value' => $request->heroTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'heroTitle';
                $newItem->value = $request->heroTitle;
                $newItem->save();
            }

            // hero tag title
            if ($heroTagTitle) {
                $heroTagTitle->update([
                    'value' => $request->heroTagTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'heroTagTitle';
                $newItem->value = $request->heroTagTitle;
                $newItem->save();
            }

            // hero badge tag title
            if ($heroBadgeTitle) {
                $heroBadgeTitle->update([
                    'value' => $request->heroBadgeTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'heroBadgeTitle';
                $newItem->value = $request->heroBadgeTitle;
                $newItem->save();
            }

            // hero tag title
            if ($heroNumber) {
                $heroNumber->update([
                    'value' => $request->heroNumber,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'heroNumber';
                $newItem->value = $request->heroNumber;
                $newItem->save();
            }

            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        }
    }
    // about section
    public function about(Request $request)
    {
        $validator = Validator::make($request->all(), [
            // 'aboutUrl' => 'required',
            'aboutTitle' => 'required',
            'aboutContent' => 'required',
            'totalItems' => 'required',

        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {
            // image
            $aboutsmImg = TemplateOne::where('name', 'aboutsmImg')->first();
            $aboutmdImg = TemplateOne::where('name', 'aboutmdImg')->first();
            $aboutlgImg = TemplateOne::where('name', 'aboutlgImg')->first();
            // content
            $totalItems = TemplateOne::where('name', 'totalItems')->first();
            $aboutTitle = TemplateOne::where('name', 'aboutTitle')->first();
            $aboutContent = TemplateOne::where('name', 'aboutContent')->first();

            //small image
            if (!is_null($request->file('aboutsmImg'))) {
                if ($aboutsmImg) {
                    // if req file heroImg
                    if ($request->hasFile('aboutsmImg')) {
                        $request->validate(
                            [
                                'aboutsmImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        // get the value from db
                        $delete_photo = $aboutsmImg->value;
                        // delete old photo
                        $checkfile = base_path('public/uploads/' . $delete_photo);
                        if (file_exists($checkfile)) {
                            unlink(base_path('public/uploads/' . $delete_photo));
                        }
                        // update
                        $photo_upload     =  $request->aboutsmImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  uniqid(rand(), true) . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);
                        $aboutsmImg->update([
                            'value' =>  $photo_name,
                        ]);
                    } else {
                        return 'invalid file from existing value';
                    }
                } else {
                    // create new one
                    if ($request->hasFile('aboutsmImg')) {
                        $request->validate(
                            [
                                'aboutsmImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $photo_upload     =  $request->aboutsmImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);

                        // set new value
                        $newItem = new TemplateOne;
                        $newItem->name = 'aboutsmImg';
                        $newItem->value =  $photo_name;
                        $newItem->save();
                    } else {
                        return 'invalid file from new one';
                    }
                }
            }

            //medium image
            if (!is_null($request->file('aboutmdImg'))) {
                if ($aboutmdImg) {
                    // if req file heroImg
                    if ($request->hasFile('aboutmdImg')) {
                        $request->validate(
                            [
                                'aboutmdImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        // get the value from db
                        $delete_photo = $aboutmdImg->value;
                        // delete old photo
                        $checkfile = base_path('public/uploads/' . $delete_photo);
                        if (file_exists($checkfile)) {
                            unlink(base_path('public/uploads/' . $delete_photo));
                        }
                        // update
                        $photo_upload     =  $request->aboutmdImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =   uniqid(rand(), true) . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);
                        $aboutmdImg->update([
                            'value' =>  $photo_name,
                        ]);
                    } else {
                        return 'invalid file from existing value';
                    }
                } else {
                    // create new one
                    if ($request->hasFile('aboutmdImg')) {
                        $request->validate(
                            [
                                'aboutmdImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $photo_upload     =  $request->aboutmdImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);

                        // set new value
                        $newItem = new TemplateOne;
                        $newItem->name = 'aboutmdImg';
                        $newItem->value =  $photo_name;
                        $newItem->save();
                    } else {
                        return 'invalid file from new one';
                    }
                }
            }

            //large image
            if (!is_null($request->file('aboutmdImg'))) {
                if ($aboutlgImg) {
                    // if req file heroImg
                    if ($request->hasFile('aboutlgImg')) {
                        $request->validate(
                            [
                                'aboutmdImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        // get the value from db
                        $delete_photo = $aboutlgImg->value;
                        // delete old photo
                        $checkfile = base_path('public/uploads/' . $delete_photo);
                        if (file_exists($checkfile)) {
                            unlink(base_path('public/uploads/' . $delete_photo));
                        }
                        // update
                        $photo_upload     =  $request->aboutlgImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =   uniqid(rand(), true) . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);
                        $aboutlgImg->update([
                            'value' =>  $photo_name,
                        ]);
                    } else {
                        return 'invalid file from existing value';
                    }
                } else {
                    // create new one
                    if ($request->hasFile('aboutlgImg')) {
                        $request->validate(
                            [
                                'aboutmdImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $photo_upload     =  $request->aboutlgImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);

                        // set new value
                        $newItem = new TemplateOne;
                        $newItem->name = 'aboutlgImg';
                        $newItem->value =  $photo_name;
                        $newItem->save();
                    } else {
                        return 'invalid file from new one';
                    }
                }
            }


            // about title
            // if($aboutUrl) {
            //     $aboutUrl->update([
            //         'value' => $request->aboutUrl,
            //     ]);
            // } else {
            //     $newItem = new TemplateOne;
            //     $newItem->name = 'aboutUrl';
            //     $newItem->value = $request->aboutUrl;
            //     $newItem->save();
            // }
            if ($totalItems) {
                $totalItems->update([
                    'value' => $request->totalItems,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'totalItems';
                $newItem->value = $request->totalItems;
                $newItem->save();
            }

            // about title
            if ($aboutTitle) {
                $aboutTitle->update([
                    'value' => $request->aboutTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'aboutTitle';
                $newItem->value = $request->aboutTitle;
                $newItem->save();
            }

            // about content
            if ($aboutContent) {
                $aboutContent->update([
                    'value' => $request->aboutContent,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'aboutContent';
                $newItem->value = $request->aboutContent;
                $newItem->save();
            }

            // enable disable about section
            $show_about_section = TemplateOne::where('name', 'show_about_section')->first();
            if ($request->enable == "true") {
                $show_about_section->value = "YES";
            } else {
                $show_about_section->value = "NO";
            }
            $show_about_section->save();

            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        }
    }
    // feature section having problem in frontend route
    public function feature(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'feaFancyTitle' => 'required',
            'feaTitle' => 'required',
            'feaContent' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {
            $feaImage = TemplateOne::where('name', 'feaImage')->first();
            $feaFancyTitle = TemplateOne::where('name', 'feaFancyTitle')->first();
            $feaTitle = TemplateOne::where('name', 'feaTitle')->first();
            $feaContent = TemplateOne::where('name', 'feaContent')->first();

            //fea image
            if (!is_null($request->file('feaImage'))) {
                if ($feaImage) {
                    // if req file heroImg
                    if ($request->hasFile('feaImage')) {
                        $request->validate(
                            [
                                'feaImage' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $validator = Validator::make($request->all(), [
                            'feaImage' => 'required|image|mimes: jpeg,png,jpg|max:10000',
                        ]);
                        // get the value from db
                        $delete_photo = $feaImage->value;
                        // delete old photo
                        $checkfile = base_path('public/uploads/' . $delete_photo);
                        if (file_exists($checkfile)) {
                            unlink(base_path('public/uploads/' . $delete_photo));
                        }
                        // update
                        $photo_upload     =  $request->feaImage;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  uniqid(rand(), true) . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);
                        $feaImage->update([
                            'value' =>  $photo_name,
                        ]);
                    } else {
                        return 'invalid file from existing value';
                    }
                } else {
                    // create new one
                    if ($request->hasFile('feaImage')) {
                        $request->validate(
                            [
                                'feaImage' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $photo_upload     =  $request->feaImage;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);

                        // set new value
                        $newItem = new TemplateOne;
                        $newItem->name = 'feaImage';
                        $newItem->value =  $photo_name;
                        $newItem->save();
                    } else {
                        return 'invalid file from new one';
                    }
                }
            }

            // fea fancy title
            if ($feaFancyTitle) {
                $feaFancyTitle->update([
                    'value' => $request->feaFancyTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'feaFancyTitle';
                $newItem->value = $request->feaFancyTitle;
                $newItem->save();
            }

            // fea  title
            if ($feaTitle) {
                $feaTitle->update([
                    'value' => $request->feaTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'feaTitle';
                $newItem->value = $request->feaTitle;
                $newItem->save();
            }

            // fea content
            if ($feaContent) {
                $feaContent->update([
                    'value' => $request->feaContent,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'feaContent';
                $newItem->value = $request->feaContent;
                $newItem->save();
            }

            // enable disable feature section
            $show_feature_section = TemplateOne::where('name', 'show_feature_section')->first();
            if ($request->enable == "true") {
                $show_feature_section->value = "YES";
            } else {
                $show_feature_section->value = "NO";
            }
            $show_feature_section->save();

            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        }
    }
    // delivery section
    public function delivery(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'deliveryFancyTitle' => 'required',
            'deliveryTitle' => 'required',
            'deliveryContent' => 'required',
            'deliveryNumber' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {
            $deliveryImg = TemplateOne::where('name', 'deliveryImg')->first();
            $deliveryFancyTitle = TemplateOne::where('name', 'deliveryFancyTitle')->first();
            $deliveryTitle = TemplateOne::where('name', 'deliveryTitle')->first();
            $deliveryContent = TemplateOne::where('name', 'deliveryContent')->first();
            $deliveryNumber = TemplateOne::where('name', 'deliveryNumber')->first();

            //delivery image
            if (!is_null($request->file('deliveryImg'))) {
                if ($deliveryImg) {
                    // if req file heroImg
                    if ($request->hasFile('deliveryImg')) {
                        $request->validate(
                            [
                                'deliveryImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        // get the value from db
                        $delete_photo = $deliveryImg->value;
                        // delete old photo
                        $checkfile = base_path('public/uploads/' . $delete_photo);
                        if (file_exists($checkfile)) {
                            unlink(base_path('public/uploads/' . $delete_photo));
                        }
                        // update
                        $photo_upload     =  $request->deliveryImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  rand(1, 1000) . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);
                        $deliveryImg->update([
                            'value' =>  $photo_name,
                        ]);
                    } else {
                        return 'invalid file from existing value';
                    }
                } else {
                    // create new one
                    if ($request->hasFile('deliveryImg')) {
                        $request->validate(
                            [
                                'deliveryImg' => 'image|mimes: jpeg,png,jpg|max:10000'
                            ]
                        );
                        $photo_upload     =  $request->deliveryImg;
                        $photo_extension  =  $photo_upload->getClientOriginalExtension();
                        $photo_name       =  time() . "." . $photo_extension;
                        $path             =  base_path('public/uploads/' . $photo_name);
                        Image::make($photo_upload)->save($path);

                        // set new value
                        $newItem = new TemplateOne;
                        $newItem->name = 'deliveryImg';
                        $newItem->value =  $photo_name;
                        $newItem->save();
                    } else {
                        return 'invalid file from new one';
                    }
                }
            }

            // delivery image title
            if ($deliveryFancyTitle) {
                $deliveryFancyTitle->update([
                    'value' => $request->deliveryFancyTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'deliveryFancyTitle';
                $newItem->value = $request->deliveryFancyTitle;
                $newItem->save();
            }

            // delivery title 
            if ($deliveryTitle) {
                $deliveryTitle->update([
                    'value' => $request->deliveryTitle,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'deliveryTitle';
                $newItem->value = $request->deliveryTitle;
                $newItem->save();
            }

            // delivery content
            if ($deliveryContent) {
                $deliveryContent->update([
                    'value' => $request->deliveryContent,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'deliveryContent';
                $newItem->value = $request->deliveryContent;
                $newItem->save();
            }

            // delivery number
            if ($deliveryNumber) {
                $deliveryNumber->update([
                    'value' => $request->deliveryNumber,
                ]);
            } else {
                $newItem = new TemplateOne;
                $newItem->name = 'deliveryNumber';
                $newItem->value = $request->deliveryNumber;
                $newItem->save();
            }

            // enable disable feature section
            $show_delivery_section = TemplateOne::where('name', 'show_delivery_section')->first();
            if ($request->enable == "true") {
                $show_delivery_section->value = "YES";
            } else {
                $show_delivery_section->value = "NO";
            }
            $show_delivery_section->save();

            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        }
    }
    // gallery section
    public function gallery(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'image' => 'required|image|mimes: jpeg,png,jpg|max:10000',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {
            $gallery = new TemplateOneGallerie;
            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $extension = $file->getClientOriginalExtension();
                $filename = uniqid(rand(), true) . '.' . $extension;
                $file->move('uploads/', $filename);
                $gallery->name = $filename;
            }
            $gallery->save();
            return response()->json([
                'status' => 200,
                'message' => 'succesfull'
            ]);
        }
    }

    // set enable/disable gallery
    public function enableGallary(Request $request)
    {
        // enable disable feature section
        $show_gallery_section = TemplateOne::where('name', 'show_gallery_section')->first();
        if ($request->enable == "true") {
            $show_gallery_section->value = "YES";
        } else {
            $show_gallery_section->value = "NO";
        }
        $show_gallery_section->save();

        return response()->json([
            'status' => 200,
            'message' => 'succesfull'
        ]);
    }

    // get gallery item
    public function getGallery()
    {
        $gallery = TemplateOneGallerie::get();
        return response()->json([
            'status' => 200,
            'gallery' => $gallery,
        ]);
    }
    // delete gallery item
    public function deleteItem($name)
    {
        $galleryItem = TemplateOneGallerie::where('name', $name)->first();
        $itemName = $galleryItem->name;
        if ($galleryItem) {
            unlink(base_path('public/uploads/' . $itemName));
            $galleryItem->delete();
            return response()->json([
                'status' => 200,
                'message' => 'Deleted successfully',
            ]);
        } else {
            return response()->json([
                'status' => 404,
                'message' => 'No category id found',
            ]);
        }
    }
    // get template all item
    public function templateAllItem()
    {
        $template = TemplateOne::get();
        return response()->json([
            'status' => 200,
            'template' => $template,
        ]);
    }

    // get hmc template data
    public function getHmcTemplateData()
    {
        $hmc_template_content_left_img = TemplateOne::where('name', 'hmc_template_content_left_img')->first();
        $hmc_template_about_right_img = TemplateOne::where('name', 'hmc_template_about_right_img')->first();
        $hmc_template_about_left_title = TemplateOne::where('name', 'hmc_template_about_left_title')->first();
        $hmc_template_about_left_des = TemplateOne::where('name', 'hmc_template_about_left_des')->first();
        $hmc_template_about_left_link = TemplateOne::where('name', 'hmc_template_about_left_link')->first();
        $hmc_template_footer_content = TemplateOne::where('name', 'hmc_template_footer_content')->first();

        return response()->json([
            'status' => 200,
            'data' => [
                'contact_img' =>  $hmc_template_content_left_img->value,
                'about_right_img' =>  $hmc_template_about_right_img->value,
                'about_left_title' =>  $hmc_template_about_left_title->value,
                'about_left_des' =>  $hmc_template_about_left_des->value,
                'about_left_link' =>  $hmc_template_about_left_link->value,
                'footer_content_des' =>  $hmc_template_footer_content->value,
            ],
        ]);
    }

    // save template home content 
    public function saveTemplateHomeContent(Request $req)
    {
        // return $req->about_left_title;
        $validator = Validator::make($req->all(), [
            'about_left_title' => 'required',
            'about_left_des' => 'required',
            'about_left_link' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 422,
                'errors' => $validator->messages(),
            ]);
        } else {

            // get all fields 
            $hmc_template_content_left_img = TemplateOne::where('name', 'hmc_template_content_left_img')->first();
            $hmc_template_about_right_img = TemplateOne::where('name', 'hmc_template_about_right_img')->first();
            $hmc_template_about_left_title = TemplateOne::where('name', 'hmc_template_about_left_title')->first();
            $hmc_template_about_left_des = TemplateOne::where('name', 'hmc_template_about_left_des')->first();
            $hmc_template_about_left_link = TemplateOne::where('name', 'hmc_template_about_left_link')->first();
            $hmc_template_footer_content = TemplateOne::where('name', 'hmc_template_footer_content')->first();


            // handle image
            if ($req->file("contact_img")) {
                $req->validate(
                    [
                        'contact_img' => 'image|mimes: jpeg,png,jpg|max:10000'
                    ]
                );
                // get the value from db
                $delete_photo = $hmc_template_content_left_img->value;

                if (!isNull($delete_photo)) {
                    // delete old photo
                    $checkfile = base_path('public/uploads/' . $delete_photo);
                    if (file_exists($checkfile)) {
                        // return "file asse";
                        unlink(base_path('public/uploads/' . $delete_photo));
                    }
                }

                // update
                $photo_upload     =  $req->file("contact_img");
                $photo_extension  =  $photo_upload->getClientOriginalExtension();
                $photo_name       =  time() . "." . $photo_extension;
                $path             =  base_path('public/uploads/' . $photo_name);
                Image::make($photo_upload)->save($path);
                $hmc_template_content_left_img->update([
                    'value' =>  $photo_name,
                ]);
            }

            if ($req->file("about_right_img")) {
                $req->validate(
                    [
                        'about_right_img' => 'image|mimes: jpeg,png,jpg|max:10000'
                    ]
                );
                // get the value from db
                $delete_photo = $hmc_template_about_right_img->value;

                if (!isNull($delete_photo)) {
                    // delete old photo
                    $checkfile = base_path('public/uploads/' . $delete_photo);
                    if (file_exists($checkfile)) {
                        // return "file asse";
                        unlink(base_path('public/uploads/' . $delete_photo));
                    }
                }

                // update
                $photo_upload     =  $req->file("about_right_img");
                $photo_extension  =  $photo_upload->getClientOriginalExtension();
                $photo_name       =  time() . "." . $photo_extension;
                $path             =  base_path('public/uploads/' . $photo_name);
                Image::make($photo_upload)->save($path);
                $hmc_template_about_right_img->update([
                    'value' =>  $photo_name,
                ]);
            }

            $hmc_template_about_left_title->value = $req->about_left_title;
            $hmc_template_about_left_title->save();

            $hmc_template_about_left_des->value = $req->about_left_des;
            $hmc_template_about_left_des->save();

            $hmc_template_about_left_link->value = $req->about_left_link;
            $hmc_template_about_left_link->save();

            $hmc_template_footer_content->value = $req->footer_content_des;
            $hmc_template_footer_content->save();

            return $this->getHmcTemplateData();
        }
    }
}
