<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FoodGroup;
use App\Models\Variation;
use App\Models\FoodItem;
use App\Models\Temporary;
use App\Models\FoodWithVariation;
use App\Models\PropertyItem;
use App\Models\PropertyGroup;
use App\Models\WorkPeriod;
use Carbon\Carbon;
use App\Models\Setting;
use App\Models\Branch;
use App\Models\FoodStockBranch;
use App\Models\OnlineOrderItem;
use App\Models\OnlineOrderGroup;
use App\Models\ShowManageStock;
use Auth;

class SaasApiController extends Controller
{

    // get_food_groups
    public function get_food_items()
    {
        $foods = FoodItem::all();
        $modifiedFoods = array();
        foreach ($foods as $food) {
            $temp = new Temporary;
            $temp->id = $food->id;

            $temp->food_group_id = $food->food_group_id;
            $foodGroup = FoodGroup::where('id', $food->food_group_id)->first();
            $temp->food_group = $foodGroup->name;

            $temp->name = $food->name;
            $temp->slug = $food->slug;
            $temp->is_special = $food->is_special;

            if (!is_null($food->image)) {
                $temp->image = asset('') . $food->image;
            } else {
                $temp->image = null;
            }

            //variations
            $temp->has_variation = $food->has_variation;
            if ($food->has_variation == 1) {
                $variations = FoodWithVariation::where('food_item_id', $food->id)->get();
                $modifiedVariations = array();
                foreach ($variations as $variation) {
                    $variationItem = Variation::where('id', $variation->variation_id)->first();
                    $tempVariation = new Temporary;

                    //food with variation table
                    $tempVariation->food_with_variation_id = $variation->id;
                    $tempVariation->food_with_variation_price = $variation->price;

                    //variation table
                    $tempVariation->variation_name = $variationItem->name;
                    array_push($modifiedVariations, $tempVariation);
                }
                $temp->variations = $modifiedVariations;
            } else {
                $temp->price = $food->price;
            }

            //properties
            $temp->has_property = $food->has_property;
            if ($food->has_property == 1) {
                $property_groups = json_decode($food->property_group_ids);
                $modifiedPropertyGroups = array();
                foreach ($property_groups as $property_group) {
                    $property_items = PropertyItem::where('property_group_id', $property_group)->get();
                    if (!is_null($property_items)) {
                        array_push($modifiedPropertyGroups, $property_items);
                    }
                }
                $temp->properties = $modifiedPropertyGroups;
                $temp->property_groups = $property_groups;
            }

            //end $foods foreach after pushing
            array_push($modifiedFoods, $temp);
        }
        return response()->json($modifiedFoods);
    }

    // get_food_is_special
    public function get_food_is_special()
    {
        $food_items = FoodItem::where('is_special', 1)->get();
        return response()->json($food_items);
    }

    // get_food_groups
    public function get_food_groups()
    {
        $food_groups = FoodGroup::all();
        return response()->json($food_groups);
    }

    // get_food_group_wise
    public function get_food_group_wise()
    {

        $food_groups = FoodItem::with(['food_group', 'variations'])->get()->groupBy('food_group_id');

        // make food_group_wise array with variations

        $modifiedFoodGroups = array();
        foreach ($food_groups as $food_group) {
            $temp = new Temporary;
            $temp->id = $food_group[0]->food_group_id;
            $temp->name = $food_group[0]->food_group->name;
            $temp->slug = $food_group[0]->food_group->slug;
            $temp->foods = $food_group;
            array_push($modifiedFoodGroups, $temp);
        }

        return response()->json($modifiedFoodGroups);
    }

    // get_food_variations
    public function get_food_variations($food_id)
    {
        $foods = FoodItem::where('id', $food_id)->with('variations.variant')->first();
        return response()->json($foods->variations);
    }

    // get_properties_items
    public function get_properties_items()
    {
        // get properties groups with items
        $property_groups = PropertyGroup::with(['properties'])->get();
        return response()->json($property_groups);
    }

    // only_food_items
    public function only_food_items()
    {
        $food_items = FoodItem::get();
        return response()->json($food_items);
    }

    // check WordPeriod is started today
    public function check_word_period(Request $request)
    {
        $branch_id = $request->branch_id;
        $today = Carbon::now()->format('Y-m-d H:i:s');
        $work_period = WorkPeriod::where('branch_id', $branch_id)
            ->where('ended_at', null)
            ->latest()->first();

        if ($work_period) {
            $epoch_ended = date('Y-m-d H:i:s', substr($work_period->started_at, 0, 10));

            if ($epoch_ended > $today) {
                $work_period_ended =  true;
            } else {
                $work_period_ended =  false;
            }

            return [
                'work_period_ended' => $work_period_ended,
                'work_period' => $work_period
            ];
        } else {
            return [
                'work_period_ended' => false,
                'work_period' => null
            ];
        }
    }

    // place_order
    public function place_order(Request $request)
    {

        //check if the work period is not ended
        $workPeriod = WorkPeriod::where('id', $request->work_period_id)->first();
        if ($workPeriod->ended_at == null) {
            //create order group
            $newGroup = new OnlineOrderGroup;
            $newGroup->work_period_id = $workPeriod->id;
            $newGroup->user_id = $request->authId;
            $newGroup->user_name = $request->name;
            $newGroup->reference = $request->reference;

            //token
            $newGroup->token = rand(2, 9999);

            //branch
            $theBranch = Branch::where('id', $request->branch_id)->first();
            $newGroup->branch_id = $request->branch_id;
            $newGroup->branch_name = $request->branch_name;

            //order bill == sub_total
            $newGroup->order_bill = $request->sub_total;
            $newGroup->vat = $request->vat_value;
            $newGroup->vat_system = getSystemSettings('vat_system');
            if (getSystemSettings('vat_system') != "igst") {
                $newGroup->cgst =  $request->sub_total * ((float)getSystemSettings('cgst') / 100);
                $newGroup->sgst = $request->sub_total * ((float)getSystemSettings('sgst') / 100);
            }
            $newGroup->total_payable = round($request->sub_total + $request->vat_value, 2);
            //payment method
            $newGroup->payment_method = "COD";
            $newGroup->payment_id = $request->payment_id;

            $newGroup->is_settled = 0;
            $newGroup->is_ready = 0;

            $newGroup->is_accepted = 0;
            $newGroup->is_accepted_by_kitchen = 0;
            $newGroup->is_cancelled = 0;
            $newGroup->note_to_rider = $request->note_to_rider ?? null;
            $newGroup->delivery_phn_no = $request->phone;
            $newGroup->delivery_address = $request->address_picked;
            $newGroup->is_delivered = 0;

            //save the group here
            $newGroup->save();

            //save each order items
            $theOrderItems = $request->carts['orders'];
            foreach ($theOrderItems as $item) {
                $newItem = new OnlineOrderItem;
                $newItem->order_group_id = $newGroup->id;

                $get_food_group_id = FoodItem::where('id', $item['food_id'])->first()->food_group_id;
                $get_food_group_name = FoodGroup::where('id', $get_food_group_id)->first()->name;

                //name and group name
                $newItem->food_item = $item['food_name'];
                $newItem->food_group = $get_food_group_name ?? null;
                $newItem->price = $item['sum'];

                //variation
                if (isset($item->order_variations)) {
                    $newItem->variation = $item['variation_name'];
                }

                //properties
                if (isset($item->order_item_properties)) {
                    $propertyArray = array();
                    foreach ($item->order_item_properties as $property) {
                        $text = new Temporary;
                        $text->property = $property->property_name;
                        $text->quantity = $property->quantity;
                        $text->price_per_qty = $property->property_price;
                        $newItem->price = $property->sum;
                        array_push($propertyArray, $text);
                    }
                    $newItem->properties = json_encode($propertyArray);
                }

                $newItem->quantity = $item['quantity']; // $item->quantity

                $newItem->is_cooking = 0;
                $newItem->is_ready = 0;
                $newItem->save();

                // check is manage stock is enable or not
                $checkShowManageStock = ShowManageStock::where('id', '1')->first()->value;

                if ($checkShowManageStock == 1) {
                    $stock = FoodStockBranch::where('branch_id', $request->branch_id)->where('food_id', $item['food_id'])->first();
                    if ($stock->qty > 0) {
                        $stock->qty = $stock->qty - $item['quantity'];
                    }
                    $stock->save();
                }
            }
            $allStock = FoodStockBranch::all();
            return $allStock;
        } else {
            //if work period is ended
            return "ended";
        }
    }

    //ENDS
}