<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\FoodGroup;
use App\Models\PropertyGroup;
use App\Models\PropertyItem;
use App\Models\FoodWithVariation;
use App\Models\Variation;

class FoodItem extends Model
{
    use HasFactory;

    // FoodGroup
    public function food_group()
    {
        return $this->hasOne(FoodGroup::class, 'id', 'food_group_id');
    }

    // PropertyGroup
    public function PropertyGroup()
    {
        return $this->hasOne(PropertyGroup::class, 'id', 'property_group_ids');
    }

    // variations
    public function variations()
    {
        return $this->hasMany(FoodWithVariation::class, 'food_item_id', 'id');
    }
    // variations
    public function recipeBuilder()
    {
        return $this->belongsTo(RecipeBuilder::class);
    }

}